/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry;

import de.uka.cmtm.serviceregistry.plugin.editors.SearchResultsEditorInput;
import de.uka.cmtm.serviceregistry.publish.uddi.WsdlPublisher;
import de.uka.cmtm.serviceregistry.publish.uddi.WsdlPublisherFactory;
import de.uka.cmtm.serviceregistry.query.ClassNotFoundEvent;
import de.uka.cmtm.serviceregistry.query.ServiceLocator;
import de.uka.cmtm.serviceregistry.query.ServiceLocatorEventListener;
import de.uka.cmtm.serviceregistry.query.ServiceLocatorFactory;
import de.uka.cmtm.serviceregistry.query.ServiceParameter;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class RegistryController
implements ServiceLocatorEventListener {
    private ServiceLocator serviceLocator;
    private WsdlPublisher wsdlPublisher;
    private IWorkbenchPage workbenchPage;
    private Shell shell;
    private ServiceLocatorFactory serviceLocatorFactory = new ServiceLocatorFactory();
    private WsdlPublisherFactory wsdlPublisherFactory = new WsdlPublisherFactory();
    private String invalidClassNames;

    public RegistryController(IWorkbenchPage workbenchPage, Shell shell) {
        this.workbenchPage = workbenchPage;
        this.shell = shell;
    }

    public void updateConfiguration(String digReasonerUrl, String serviceOntologyUrl, String upperOntologyUrl, String topOntologyUrl, String uddiInquiryUrl, String uddiPublishUrl, String uddiUserName, String uddiPassword) {
        if (this.serviceLocator != null) {
            this.serviceLocator.removeServiceLocatorEventListener((ServiceLocatorEventListener)this);
        }
        this.serviceLocator = null;
        this.serviceLocatorFactory.setDigReasonerUrl(digReasonerUrl);
        this.serviceLocatorFactory.setServiceOntologyUrl(serviceOntologyUrl);
        this.serviceLocatorFactory.setUpperServiceOntologyUrl(upperOntologyUrl);
        this.serviceLocatorFactory.setTopOntologyUrl(topOntologyUrl);
        this.serviceLocatorFactory.setUddiInquiryUrl(uddiInquiryUrl);
        this.wsdlPublisher = null;
        this.wsdlPublisherFactory.setSaWsdlPublishingCapable(true);
        this.wsdlPublisherFactory.setUpperServiceOntologyUrl(upperOntologyUrl);
        this.wsdlPublisherFactory.setUddiInquiryUrl(uddiInquiryUrl);
        this.wsdlPublisherFactory.setUddiPublishUrl(uddiPublishUrl);
        this.wsdlPublisherFactory.setUddiUser(uddiUserName);
        this.wsdlPublisherFactory.setUddiPassword(uddiPassword);
    }

    public void publishWsdl(String wsdlUrl, String businessName) {
        if (this.wsdlPublisher == null) {
            try {
                this.wsdlPublisher = this.wsdlPublisherFactory.createWsdlPublisher();
            }
            catch (InstantiationException e) {
                this.displayErrorMsg("Problem while creating wsdl publisher.", e);
            }
        }
        if (this.wsdlPublisher != null) {
            try {
                this.wsdlPublisher.publishWsdl(wsdlUrl, businessName, null);
                MessageDialog.openInformation((Shell)this.shell, (String)"Success", (String)"WSDL published successfully.");
            }
            catch (Exception e) {
                this.displayErrorMsg("Problem while publishing.", e);
            }
        }
    }

    public void findServices(ServiceParameter searchParameter) {
        if (this.serviceLocator == null) {
            try {
                this.serviceLocator = this.serviceLocatorFactory.createServiceLocator();
            }
            catch (InstantiationException e) {
                this.displayErrorMsg("Problem while creating service locator.", e);
            }
            this.serviceLocator.addServiceLocatorEventListener((ServiceLocatorEventListener)this);
        }
        if (this.serviceLocator != null) {
            try {
                this.invalidClassNames = null;
                List results = this.serviceLocator.findServices(searchParameter);
                if (this.invalidClassNames != null) {
                    MessageDialog.openInformation((Shell)this.shell, (String)"Class not found.", (String)("The classes " + this.invalidClassNames + " could not be found in the ontology and have been ignored during search."));
                }
                this.workbenchPage.openEditor((IEditorInput)new SearchResultsEditorInput(results), "de.uka.cmtm.serviceregistry.plugin.editors.SearchResultsEditor");
            }
            catch (Exception e) {
                this.displayErrorMsg("Problem while querrying.", e);
            }
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    public void setWorkbenchPage(IWorkbenchPage workbenchPage) {
        this.workbenchPage = workbenchPage;
    }

    private Throwable getCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private void displayErrorMsg(String msg, Throwable t) {
        Platform.getPlugin((String)"de.uka.cmtm.serviceregistry").getLog().log((IStatus)new Status(4, "de.uka.cmtm.serviceregistry", 1, msg, t));
        Throwable cause = this.getCause(t);
        String exMsg = cause.getMessage();
        if (cause instanceof NullPointerException) {
            exMsg = "A NullPointerException occured.";
        }
        MessageDialog.openError((Shell)this.shell, (String)msg, (String)exMsg);
    }

    public void classNotFound(ClassNotFoundEvent e) {
        this.invalidClassNames = this.invalidClassNames == null ? e.getClassName() : String.valueOf(this.invalidClassNames) + ", " + e.getClassName();
    }
}

