/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.plugin.editors;

import de.uka.cmtm.serviceregistry.query.ServiceInfo;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultsEditorInput
implements IEditorInput {
    private String html;

    public SearchResultsEditorInput(Collection<ServiceInfo> searchResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>Search Results</title></head><body>");
        sb.append("<h1>").append(searchResults.size()).append(" Search Result");
        if (searchResults.size() == 0 || searchResults.size() > 1) {
            sb.append("s");
        }
        sb.append("</h1>");
        int i = 1;
        if (!searchResults.isEmpty()) {
            for (ServiceInfo si : searchResults) {
                sb.append("<table border='1' cellspacing='0' width='100%'>");
                sb.append("<tr>");
                sb.append("<td><h3>#").append(i++).append("</h3></td><td><h3>");
                sb.append("Relevanz ").append(String.format("%1$.3f", si.getRelevance()));
                sb.append("</h3></td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Description:</b></td><td>");
                sb.append(si.getDescription() != null ? si.getDescription() : "&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Business Name:</b></td><td>");
                sb.append(si.getBusinessName());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Service Category:</b></td><td>");
                sb.append(si.getCategory());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>User Roles:</b></td><td>");
                sb.append(si.getUserRolesCsv());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Inputs:</b></td><td>");
                sb.append(si.getLogicalInputsCsv());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Outputs:</b></td><td>");
                sb.append(si.getLogicalOutputsCsv());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Preconditions:</b></td><td>");
                sb.append(si.getPreconditionsCsv());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Effects:</b></td><td>");
                sb.append(si.getEffectsCsv());
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>Service Profile:</b></td><td>");
                sb.append("<a target='_blank' href='");
                sb.append(si.getProfileUri());
                sb.append("'>");
                sb.append(si.getProfileUri());
                sb.append("</a>");
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td><b><nobr>WSDL-S Location:</nobr></b></td><td>");
                sb.append("<a target='_blank' href='");
                sb.append(si.getWsdlLocation());
                sb.append("'>");
                sb.append(si.getWsdlLocation());
                sb.append("</a>");
                sb.append("&nbsp;");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("</table>");
                sb.append("<p><br></p>");
            }
        }
        sb.append("</html>");
        this.html = sb.toString();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "Search Results";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "The search results of a semantic service search.";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getHtml() {
        return this.html;
    }
}

