/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.database.triplestore.DatabaseTripleStoreModel;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.LocalClassificationFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameFactoryInvocationHandler;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.util.List;
import java.util.logging.Logger;

public class OWLDatabaseModel
extends AbstractOWLModel
implements OntModelProvider {
    private static transient Logger log = Log.getLogger(OWLDatabaseModel.class);
    private TripleStoreModel tripleStoreModel;

    public OWLDatabaseModel(KnowledgeBaseFactory factory) {
        super(factory);
    }

    public void initializeClient() {
        this.getOWLSystemFramesArray();
        this.initialize();
    }

    public void initialize() {
        OWLNamespaceManager namespaceManager = new OWLNamespaceManager();
        super.initialize(namespaceManager);
        this.initCustomFrameStores();
        this.setFrameFactory((FrameFactory)new OWLJavaFactory(this));
        this.adjustThing();
        this.adjustSystemClasses();
        this.getNamespaceManager().update();
    }

    public OWLOntology getDefaultOWLOntology() {
        OWLOntology ontology = super.getDefaultOWLOntology();
        if (ontology == null) {
            this.createDefaultOWLOntologyReally();
            return super.getDefaultOWLOntology();
        }
        return ontology;
    }

    public OntModel getOntModel() {
        long startTime = System.currentTimeMillis();
        JenaCreator creator = new JenaCreator(this, false, null, new ModalProgressBarManager("Converting Ontology"));
        OntModel ontModel = creator.createOntModel();
        long endTime = System.currentTimeMillis();
        System.out.println("[OWLDatabaseModel.getOntModel] Duration " + (endTime - startTime));
        return ontModel;
    }

    public OntModel getOWLDLOntModel() {
        long startTime = System.currentTimeMillis();
        JenaCreator creator = new JenaCreator(this, true, null, new ModalProgressBarManager("Preparing Ontology"));
        OntModel ontModel = creator.createOntModel();
        long endTime = System.currentTimeMillis();
        System.out.println("[OWLDatabaseModel.getOWLDLOntModel] Duration " + (endTime - startTime));
        return ontModel;
    }

    public int getOWLSpecies() {
        OntModel ontModel = this.getOntModel();
        return Jena.getOWLSpecies(ontModel);
    }

    public OntModel getReasonerOntModel(String classifierURL) {
        Model newModel = ModelFactory.createDefaultModel();
        Resource resource = newModel.createResource("http://foo.de#foo");
        newModel.add(resource, ReasonerVocabulary.EXT_REASONER_URL, classifierURL);
        DIGReasoner reasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", resource);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)reasoner);
        OntModel m = Jena.cloneOntModel(this.getOntModel(), spec);
        return m;
    }

    public String getNextAnonymousResourceName() {
        int rand;
        String name;
        while (this.getFrame(name = "@" + (rand = (int)(Math.random() * 1000000.0))) != null) {
        }
        return name;
    }

    public TripleStoreModel getTripleStoreModel() {
        if (this.tripleStoreModel == null) {
            this.tripleStoreModel = new DatabaseTripleStoreModel(this);
        }
        return this.tripleStoreModel;
    }

    public void setTripleStoreModel(TripleStoreModel tripleStoreModel) {
        this.tripleStoreModel = tripleStoreModel;
    }

    public void initCustomFrameStores() {
        this.initOWLFrameStore();
    }

    public void initDefaultNamespaces() {
        NamespaceManager namespaceManager = this.getNamespaceManager();
        namespaceManager.setPrefix(OWL.getURI(), "owl");
        namespaceManager.setPrefix(RDF.getURI(), "rdf");
        namespaceManager.setPrefix(RDFS.getURI(), "rdfs");
        namespaceManager.setPrefix("http://www.w3.org/2001/XMLSchema#", "xsd");
        namespaceManager.setModifiable("owl", false);
        namespaceManager.setModifiable("rdf", false);
        namespaceManager.setModifiable("rdfs", false);
        namespaceManager.setModifiable("xsd", false);
    }

    public void initOWLFrameFactoryInvocationHandler() {
        Class<OWLFrameFactoryInvocationHandler> clazz = OWLFrameFactoryInvocationHandler.class;
        FrameStore frameFactoryInvocationFrameStore = AbstractFrameStoreInvocationHandler.newInstance(clazz, (KnowledgeBase)this);
        List frameStores = this.getFrameStores();
        int index = 0;
        while (!(frameStores.get(index) instanceof EventGeneratorFrameStore)) {
            ++index;
        }
        this.insertFrameStore(frameFactoryInvocationFrameStore, index - 1);
    }

    public void resetTripleStoreModel() {
        this.tripleStoreModel = null;
    }

    public void setProject(Project project) {
        super.setProject(project);
        if (!project.isMultiUserServer()) {
            int position = this.getFrameStores().size() - 1;
            if (!(this.getFrameStores().get(position) instanceof LocalClassificationFrameStore)) {
                this.insertFrameStore((FrameStore)new LocalClassificationFrameStore(this), position);
            }
        }
    }
}

