/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.export;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public abstract class AbstractJenaFileExportPlugin
implements ExportPlugin {
    private String lang;

    protected AbstractJenaFileExportPlugin(String lang) {
        this.lang = lang;
    }

    public void dispose() {
    }

    public String getName() {
        return this.lang;
    }

    public void handleExportRequest(Project project) {
        KnowledgeBase kb = project.getKnowledgeBase();
        if (kb instanceof JenaOWLModel) {
            JenaOWLModel owlModel = (JenaOWLModel)kb;
            ArrayList errors = new ArrayList();
            JFileChooser fileChooser = OWLUI.createJFileChooser(this.lang, JenaKnowledgeBaseFactory.getExtension(this.lang));
            if (fileChooser.showSaveDialog(ProtegeUI.getTopLevelContainer(kb.getProject())) == 0) {
                URI fileURI = fileChooser.getSelectedFile().toURI();
                owlModel.save(fileURI, this.lang, errors);
                if (errors.isEmpty()) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Successfully exported to " + fileURI);
                } else {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not export:\n" + errors.iterator().next());
                }
            }
        } else {
            ProjectView projectView = ProtegeUI.getProjectView(project);
            ProtegeUI.getModalDialogFactory().showMessageDialog((Component)projectView, "This function can only export OWL File projects.");
        }
    }
}

