/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;
import java.util.List;

public class LoadSWRLTestCase
extends AbstractJenaTestCase {
    public void testAddSWRLImport() throws Exception {
        this.owlModel.getNamespaceManager().setPrefix("http://www.w3.org/2003/11/swrl", "swrlImport");
        this.owlModel.getNamespaceManager().setPrefix("http://www.w3.org/2003/11/swrlb", "swrlbImport");
        ProtegeOWLParser.addImport(this.owlModel, new URI("http://www.w3.org/2003/11/swrl"));
        ProtegeOWLParser.addImport(this.owlModel, new URI("http://www.w3.org/2003/11/swrlb"));
        RDFResource atomListClass = this.owlModel.getRDFResource("swrl:AtomList");
        LoadSWRLTestCase.assertTrue((boolean)(atomListClass instanceof OWLNamedClass));
    }

    public void testImportSWRL() throws Exception {
        JenaOWLModel newModel = LoadSWRLTestCase.reload(this.owlModel);
        newModel.copyFacetValuesIntoNamedClses();
        newModel.getOntModel();
    }

    public void testLoadSWRL() throws Exception {
        this.loadTestOntology(new URI("http://www.daml.org/2004/04/swrl/swrl.owl"));
        RDFProperty argument2Property = (RDFProperty)this.owlModel.getSlot("swrl:argument2");
        LoadSWRLTestCase.assertNotNull((Object)argument2Property);
        LoadSWRLTestCase.assertNull((Object)argument2Property.getRange());
        OWLNamedClass datavaluedPropertyAtomCls = (OWLNamedClass)this.owlModel.getCls("swrl:DatavaluedPropertyAtom");
        LoadSWRLTestCase.assertNotNull((Object)datavaluedPropertyAtomCls);
        OWLNamedClass dataRangeAtomCls = (OWLNamedClass)this.owlModel.getCls("swrl:DataRangeAtom");
        LoadSWRLTestCase.assertNotNull((Object)dataRangeAtomCls);
        OWLObjectProperty dataRangeSlot = this.owlModel.getOWLObjectProperty("swrl:dataRange");
        LoadSWRLTestCase.assertNotNull((Object)dataRangeSlot);
    }

    public void testLoadSWRLDataRangeAtom() throws Exception {
        this.loadRemoteOntology("SWRLDataRange.owl");
        Instance dataRange = this.owlModel.getInstance("MyDataRange");
        Slot oneOfSlot = this.owlModel.getSlot("owl:oneOf");
        List values = dataRange.getDirectOwnSlotValues(oneOfSlot);
        LoadSWRLTestCase.assertSize(2, values);
        LoadSWRLTestCase.assertContains((Object)"10", values);
        LoadSWRLTestCase.assertContains((Object)"15", values);
    }

    public void testLoadAtomList() throws Exception {
        this.loadRemoteOntology("swrlRules.owl");
        RDFResource imp = this.owlModel.getRDFResource("Rule-1");
        LoadSWRLTestCase.assertTrue((boolean)(imp instanceof SWRLImp));
    }
}

