/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ParseQuantifierRestrictionsTestCase
extends AbstractJenaTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testParseOWLAllValuesFromWithOWLDatatypeProperty() throws Exception {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        RDFSClass result = this.parser.parseClass(this.owlModel, "property * double");
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(result instanceof OWLAllValuesFrom));
        OWLAllValuesFrom allValuesFrom = (OWLAllValuesFrom)result;
        ParseQuantifierRestrictionsTestCase.assertEquals((Object)property, (Object)allValuesFrom.getOnProperty());
        ParseQuantifierRestrictionsTestCase.assertEquals((Object)this.owlModel.getXSDdouble(), (Object)allValuesFrom.getAllValuesFrom());
        try {
            this.parser.parseClass(this.owlModel, "property * dou");
            ParseQuantifierRestrictionsTestCase.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFailParseRestrictionsWithDatatypeProperty() {
        this.owlModel.createOWLDatatypeProperty("children", this.owlModel.getXSDstring());
        this.owlModel.createOWLNamedClass("RichPerson");
        try {
            this.parser.parseClass(this.owlModel, "children * RichPerson");
            ParseQuantifierRestrictionsTestCase.assertTrue((String)"Expected parser to fail", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.parser.parseClass(this.owlModel, "children ? RichPerson");
            ParseQuantifierRestrictionsTestCase.assertTrue((String)"Expected parser to fail", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFailParseRestrictionsWithObjectProperty() {
        this.owlModel.createOWLObjectProperty("property");
        try {
            this.parser.parseClass(this.owlModel, "property ? xsd:int");
            ParseQuantifierRestrictionsTestCase.assertTrue((String)"Expected parser to fail", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.parser.parseClass(this.owlModel, "property ? xsd:int");
            ParseQuantifierRestrictionsTestCase.assertTrue((String)"Expected parser to fail", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testParseAllRestriction() throws Exception {
        this.owlModel.createOWLObjectProperty("children");
        this.owlModel.createOWLNamedClass("RichPerson");
        String expression = "children * RichPerson";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLAllValuesFrom));
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)aClass;
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("children"));
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getFiller().getName().equals("RichPerson"));
    }

    public void testParseAllRestrictionDataType() throws Exception {
        this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDstring());
        String expression = "property * int";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLAllValuesFrom));
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)aClass;
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("property"));
        ParseQuantifierRestrictionsTestCase.assertEquals((Object)restriction.getFiller(), (Object)this.owlModel.getXSDint());
    }

    public void testParseAllRestrictionDataTypeAbbrev() throws Exception {
        this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDstring());
        String expression = "property * int";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLAllValuesFrom));
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)aClass;
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("property"));
        ParseQuantifierRestrictionsTestCase.assertEquals((Object)restriction.getFiller(), (Object)this.owlModel.getXSDint());
    }

    public void testParseSomeValuesFromWithNamedClass() throws Exception {
        this.owlModel.createOWLNamedClass("RichPerson");
        this.owlModel.createOWLObjectProperty("children");
        String expression = "children ? RichPerson";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLSomeValuesFrom));
        OWLSomeValuesFrom restriction = (OWLSomeValuesFrom)aClass;
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("children"));
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getFiller().getName().equals("RichPerson"));
    }

    public void testParseSomeValuesFromWithAnonymousClass() throws Exception {
        this.owlModel.createOWLNamedClass("RichPerson");
        this.owlModel.createOWLObjectProperty("children");
        String expression = "children ? !RichPerson";
        this.parser.checkClass(this.owlModel, expression);
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLSomeValuesFrom));
        OWLSomeValuesFrom restriction = (OWLSomeValuesFrom)aClass;
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("children"));
        ParseQuantifierRestrictionsTestCase.assertTrue((boolean)(restriction.getFiller() instanceof OWLComplementClass));
    }
}

