/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.framestore.RestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.ArrayList;
import java.util.Collection;

abstract class AbstractRestrictionUpdater
implements RestrictionUpdater {
    protected AbstractOWLModel owlModel;

    public AbstractRestrictionUpdater(AbstractOWLModel owlModel) {
        this.owlModel = owlModel;
    }

    protected Cls getDirectRestriction(Cls cls, Slot slot, Class metaClass) {
        for (Cls superCls : cls.getDirectSuperclasses()) {
            RDFProperty restrictedSlot;
            if (!metaClass.isAssignableFrom(superCls.getClass()) || !slot.equals(restrictedSlot = ((OWLRestriction)superCls).getOnProperty())) continue;
            return superCls;
        }
        return null;
    }

    protected Collection getDirectRestrictions(Cls cls, Slot slot, Class metaClass) {
        ArrayList<Cls> result = new ArrayList<Cls>();
        for (Cls superCls : cls.getDirectSuperclasses()) {
            RDFProperty restrictedSlot;
            if (!metaClass.isAssignableFrom(superCls.getClass()) || (restrictedSlot = ((OWLRestriction)superCls).getOnProperty()) == null || !restrictedSlot.equals(slot)) continue;
            result.add(superCls);
        }
        return result;
    }

    protected void log(String message) {
    }

    protected void removeRestrictions(Cls cls, Slot slot, Cls metaCls) {
        ArrayList copy = new ArrayList(cls.getDirectSuperclasses());
        for (Cls superCls : copy) {
            OWLRestriction restriction;
            RDFProperty restrictedSlot;
            if (!superCls.getDirectType().equals(metaCls) || !(restrictedSlot = (restriction = (OWLRestriction)superCls).getOnProperty()).equals(slot)) continue;
            this.log("- OWLRestriction " + restriction.getBrowserText() + " from " + cls.getName() + "." + slot.getName());
            cls.removeDirectSuperclass((Cls)restriction);
        }
    }
}

