/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class AllValuesFromRestrictionUpdaterTestCase
extends AbstractJenaTestCase {
    public void testChangeAllRestrictions() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("HappyPerson");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("OtherPerson");
        aCls.addSuperclass(personCls);
        bCls.addSuperclass(personCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        property.setUnionRangeClasses(Collections.singleton(personCls));
        property.addUnionDomainClass(personCls);
        int oldClsCount = this.owlModel.getClsCount();
        Facet valueTypeFacet = this.owlModel.getFacet(":VALUE-TYPE");
        OWLAllValuesFrom aRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, aCls);
        personCls.addSuperclass(aRestriction);
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)personCls.hasDirectlyOverriddenTemplateFacet(property, valueTypeFacet));
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)1, (int)personCls.getTemplateSlotAllowedClses(property).size());
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((Object)aCls, personCls.getTemplateSlotAllowedClses(property).iterator().next());
        OWLAllValuesFrom bRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, bCls);
        personCls.addSuperclass(bRestriction);
        AllValuesFromRestrictionUpdaterTestCase.assertFalse((boolean)personCls.hasDirectlyOverriddenTemplateFacet(property, valueTypeFacet));
        personCls.removeSuperclass(aRestriction);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)1, (int)personCls.getTemplateSlotAllowedClses(property).size());
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((Object)bCls, personCls.getTemplateSlotAllowedClses(property).iterator().next());
        personCls.removeSuperclass(bRestriction);
        AllValuesFromRestrictionUpdaterTestCase.assertFalse((boolean)personCls.hasDirectlyOverriddenTemplateFacet(property, valueTypeFacet));
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(aCls);
        OWLUnionClass union = this.owlModel.createOWLUnionClass(Arrays.asList(complementCls, bCls));
        OWLAllValuesFrom bothRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, union);
        personCls.addSuperclass(bothRestriction);
        Collection templateSlotAllowedClses = personCls.getTemplateSlotAllowedClses(property);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)2, (int)templateSlotAllowedClses.size());
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)templateSlotAllowedClses.contains(complementCls));
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)templateSlotAllowedClses.contains(bCls));
        personCls.removeSuperclass(bothRestriction);
        OWLIntersectionClass intersection = this.owlModel.createOWLIntersectionClass(Arrays.asList(aCls, this.owlModel.createOWLComplementClass(bCls)));
        OWLAllValuesFrom intersectionRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, intersection);
        personCls.addSuperclass(intersectionRestriction);
        templateSlotAllowedClses = personCls.getTemplateSlotAllowedClses(property);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)1, (int)templateSlotAllowedClses.size());
        personCls.removeSuperclass(intersectionRestriction);
        AllValuesFromRestrictionUpdaterTestCase.assertFalse((boolean)personCls.hasDirectlyOverriddenTemplateFacet(property, valueTypeFacet));
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
    }

    public void testComplexAllRestrictions() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass cCls = this.owlModel.createOWLNamedClass("C");
        bCls.addSuperclass(aCls);
        cCls.addSuperclass(aCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        property.setUnionRangeClasses(Collections.singleton(aCls));
        property.addUnionDomainClass(aCls);
        int oldClsCount = this.owlModel.getClsCount();
        Facet valueTypeFacet = this.owlModel.getFacet(":VALUE-TYPE");
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass(Arrays.asList(bCls, cCls));
        OWLComplementClass complementClass = this.owlModel.createOWLComplementClass(unionCls);
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, complementClass);
        bCls.addSuperclass(restriction);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)1, (int)bCls.getTemplateSlotAllowedClses(property).size());
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((Object)complementClass, bCls.getTemplateSlotAllowedClses(property).iterator().next());
        bCls.removeSuperclass(restriction);
        AllValuesFromRestrictionUpdaterTestCase.assertFalse((boolean)bCls.hasDirectlyOverriddenTemplateFacet(property, valueTypeFacet));
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
    }

    public void testChangeAllFacets() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("HappyPerson");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("OtherPerson");
        aCls.addSuperclass(personCls);
        bCls.addSuperclass(personCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        property.setRange(personCls);
        property.setDomain(personCls);
        int oldClsCount = this.owlModel.getClsCount();
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)1, (int)personCls.getSuperclassCount());
        personCls.setTemplateSlotValueType(property, ValueType.INSTANCE);
        personCls.setTemplateSlotAllowedClses(property, Collections.singleton(aCls));
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        OWLAllValuesFrom oldRestriction = (OWLAllValuesFrom)personCls.getSuperclasses(false).toArray()[1];
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((Object)aCls, (Object)oldRestriction.getFiller());
        OWLIntersectionClass i = this.owlModel.createOWLIntersectionClass(Arrays.asList(bCls, aCls));
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(aCls);
        personCls.setTemplateSlotAllowedClses(property, Arrays.asList(complementCls, i));
        Collection supers = personCls.getSuperclasses(false);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)2, (int)supers.size());
        OWLAllValuesFrom unionRestriction = (OWLAllValuesFrom)supers.toArray()[1];
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)(unionRestriction.getFiller() instanceof OWLUnionClass));
        Collection operands = ((OWLUnionClass)unionRestriction.getFiller()).getOperands();
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)operands.contains(complementCls));
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)operands.contains(i));
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)this.owlModel.containsFrame(complementCls.getName()));
        personCls.setTemplateSlotAllowedClses(property, Collections.singleton(complementCls));
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        OWLAllValuesFrom newRestriction = (OWLAllValuesFrom)personCls.getSuperclasses(false).toArray()[1];
        AllValuesFromRestrictionUpdaterTestCase.assertTrue((boolean)newRestriction.getFiller().equals(complementCls));
        personCls.setTemplateSlotAllowedClses(property, Collections.EMPTY_LIST);
        personCls.setTemplateFacetValues(property, this.owlModel.getFacet(":VALUE-TYPE"), Collections.EMPTY_LIST);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
    }

    public void testXMLLiteral() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("slot");
        property.addUnionDomainClass(c);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((Object)ValueType.ANY, (Object)c.getTemplateSlotValueType(property));
        OWLAllValuesFrom allValuesFrom = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getRDFXMLLiteralType());
        c.addSuperclass(allValuesFrom);
        AllValuesFromRestrictionUpdaterTestCase.assertEquals((Object)ValueType.STRING, (Object)c.getTemplateSlotValueType(property));
    }
}

