/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DeleteTestCase
extends AbstractJenaTestCase {
    private OWLObjectProperty childrenSlot;
    private OWLNamedClass genderCls;
    private OWLObjectProperty genderSlot;
    private Instance male;
    private OWLNamedClass personCls;

    private void setup() {
        this.personCls = this.owlModel.createOWLNamedClass("Person");
        this.childrenSlot = this.owlModel.createOWLObjectProperty("children");
        this.genderCls = this.owlModel.createOWLNamedClass("Gender");
        this.male = this.genderCls.createInstance("male");
        this.genderSlot = this.owlModel.createOWLObjectProperty("gender");
        this.genderSlot.setRange(this.genderCls);
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(this.genderSlot, this.male);
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)this.childrenSlot, hasRestriction);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(allRestriction);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(this.personCls);
        intersectionCls.addOperand(complementCls);
    }

    public void testDeletePerson() {
        int count = this.owlModel.getClsCount();
        this.setup();
        this.personCls.delete();
        DeleteTestCase.assertEquals((int)(count + 1), (int)this.owlModel.getClsCount());
    }

    public void testDeleteInstance() {
        this.setup();
        int count = this.owlModel.getInstanceCount(this.genderCls);
        this.male.delete();
        DeleteTestCase.assertEquals((int)(count - 1), (int)this.owlModel.getInstanceCount(this.genderCls));
        Frame test = this.owlModel.getFrame("male");
        DeleteTestCase.assertNull((Object)test);
    }
}

