/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collections;

public class SubclassesDisjointTestCase
extends AbstractJenaTestCase {
    public void testCreateSubclassesOfUnflaggedCls() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        OWLNamedClass subClsA = this.owlModel.createOWLNamedSubclass("A", cls);
        OWLNamedClass subClsB = this.owlModel.createOWLNamedSubclass("B", cls);
        SubclassesDisjointTestCase.assertSize(0, subClsA.getDisjointClasses());
        SubclassesDisjointTestCase.assertSize(0, subClsB.getDisjointClasses());
    }

    public void testCreateSubclassesOfFlaggedCls() throws Exception {
        this.loadRemoteOntology("import-protege.owl");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        cls.setSubclassesDisjoint(true);
        OWLNamedClass subClsA = this.owlModel.createOWLNamedSubclass("A", cls);
        OWLNamedClass subClsB = this.owlModel.createOWLNamedSubclass("B", cls);
        SubclassesDisjointTestCase.assertSize(1, subClsA.getDisjointClasses());
        SubclassesDisjointTestCase.assertEquals((Object)subClsB, subClsA.getDisjointClasses().iterator().next());
        SubclassesDisjointTestCase.assertSize(1, subClsB.getDisjointClasses());
        SubclassesDisjointTestCase.assertEquals((Object)subClsA, subClsB.getDisjointClasses().iterator().next());
    }

    public void testCreateSubclassesOfFlaggedCls2() throws Exception {
        this.loadRemoteOntology("import-protege.owl");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        cls.setSubclassesDisjoint(true);
        OWLNamedClass subClsA = (OWLNamedClass)this.owlModel.createCls("A", Collections.singleton(cls));
        OWLNamedClass subClsB = (OWLNamedClass)this.owlModel.createCls("B", Collections.singleton(cls));
        SubclassesDisjointTestCase.assertSize(1, subClsA.getDisjointClasses());
        SubclassesDisjointTestCase.assertEquals((Object)subClsB, subClsA.getDisjointClasses().iterator().next());
        SubclassesDisjointTestCase.assertSize(1, subClsB.getDisjointClasses());
        SubclassesDisjointTestCase.assertEquals((Object)subClsA, subClsB.getDisjointClasses().iterator().next());
    }

    public void testCreateSubclassesAndFlagCls() throws Exception {
        this.loadRemoteOntology("import-protege.owl");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        OWLNamedClass subClsA = this.owlModel.createOWLNamedSubclass("A", cls);
        OWLNamedClass subClsB = this.owlModel.createOWLNamedSubclass("B", cls);
        OWLNamedClass subClsC = this.owlModel.createOWLNamedSubclass("C", cls);
        cls.setSubclassesDisjoint(true);
        SubclassesDisjointTestCase.assertSize(2, subClsA.getDisjointClasses());
        SubclassesDisjointTestCase.assertSize(2, subClsB.getDisjointClasses());
        SubclassesDisjointTestCase.assertSize(2, subClsC.getDisjointClasses());
    }
}

