/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.factory;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.DublinCoreDLVersionRedirectRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.FTPRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFolderRepositoryFactoryPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class RepositoryFactory {
    private static RepositoryFactory instance;
    private ArrayList factories = new ArrayList();

    private RepositoryFactory() {
        this.factories.add(new DublinCoreDLVersionRedirectRepositoryFactoryPlugin());
        this.factories.add(new LocalFileRepositoryFactoryPlugin());
        this.factories.add(new LocalFolderRepositoryFactoryPlugin());
        this.factories.add(new HTTPRepositoryFactoryPlugin());
        this.factories.add(new RelativeFolderRepositoryFactoryPlugin());
        this.factories.add(new FTPRepositoryFactoryPlugin());
        Collection plugins = PluginUtilities.getClassesWithAttribute((String)"RepositoryFactoryPlugin", (String)"True");
        for (Class cls : plugins) {
            try {
                this.factories.add(cls.newInstance());
            }
            catch (InstantiationException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
            catch (IllegalAccessException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
        }
    }

    public static RepositoryFactory getInstance() {
        if (instance == null) {
            instance = new RepositoryFactory();
        }
        return instance;
    }

    public void registerRepositoryFactoryPlugin(RepositoryFactoryPlugin factory) {
        this.factories.add(factory);
    }

    public Repository createOntRepository(OWLModel model, String s) {
        for (RepositoryFactoryPlugin curPlugin : this.factories) {
            if (!curPlugin.isSuitable(model, s)) continue;
            return curPlugin.createRepository(model, s);
        }
        return null;
    }

    public Collection getFactories() {
        return new ArrayList(this.factories);
    }
}

