/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactParserUtil;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class OWLTextFormatter {
    private static OWLClassDisplay display = OWLClassDisplayFactory.getDefaultDisplay();
    private static final String[][] charMap = new String[][]{{"<", display.getOWLMaxCardinalitySymbol()}, {"=", display.getOWLCardinalitySymbol()}, {">", display.getOWLMinCardinalitySymbol()}, {"*", display.getOWLAllValuesFromSymbol()}, {"?", display.getOWLSomeValuesFromSymbol()}, {"$", display.getOWLHasValueSymbol()}, {"!", display.getOWLComplementOfSymbol()}, {"&", display.getOWLIntersectionOfSymbol()}, {"|", display.getOWLUnionOfSymbol()}};
    private static final Hashtable symbolMap = new Hashtable();

    static {
        symbolMap.put("all", display.getOWLAllValuesFromSymbol());
        symbolMap.put("allValuesFrom", display.getOWLAllValuesFromSymbol());
        symbolMap.put("forall", display.getOWLAllValuesFromSymbol());
        symbolMap.put("only", display.getOWLAllValuesFromSymbol());
        symbolMap.put("some", display.getOWLSomeValuesFromSymbol());
        symbolMap.put("someValuesFrom", display.getOWLSomeValuesFromSymbol());
        symbolMap.put("exists", display.getOWLSomeValuesFromSymbol());
        symbolMap.put("has", display.getOWLHasValueSymbol());
        symbolMap.put("hasValue", display.getOWLHasValueSymbol());
        symbolMap.put("value", display.getOWLHasValueSymbol());
        symbolMap.put("and", display.getOWLIntersectionOfSymbol());
        symbolMap.put("or", display.getOWLUnionOfSymbol());
        symbolMap.put("not", display.getOWLComplementOfSymbol());
    }

    public static String getDisplayString(String str) {
        int originalLength = str.length();
        String n = "";
        StringTokenizer tokenizer = new StringTokenizer(str, " \t\n,(){}[]", true);
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1) {
                char c = token.charAt(0);
                int i = 0;
                while (i < charMap.length) {
                    String[] chars = charMap[i];
                    if (chars[0].charAt(0) == c) {
                        token = chars[1];
                        break;
                    }
                    ++i;
                }
            }
            index += token.length();
            String symbol = (String)symbolMap.get(token);
            n = symbol != null && index < originalLength ? String.valueOf(n) + symbol : String.valueOf(n) + token;
        }
        return n;
    }

    public static String getParseableString(String str) {
        return CompactParserUtil.getParseableString(str);
    }

    public static void initKeymap(JTextComponent textComponent) {
        textComponent.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                int i = 0;
                while (i < charMap.length) {
                    String[] chars = charMap[i];
                    if (chars[0].charAt(0) == ch) {
                        JTextComponent c = (JTextComponent)evt.getSource();
                        try {
                            c.getDocument().insertString(c.getCaretPosition(), chars[1], null);
                            evt.consume();
                            return;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public static void updateSyntax(JTextComponent textComponent) {
        OWLTextFormatter.updateSyntax(textComponent, null);
    }

    public static void updateSyntax(JTextComponent textComponent, OWLModel owlModel) {
        OWLTextFormatter.updateSyntax(textComponent, owlModel, symbolMap);
    }

    public static void updateSyntax(JTextComponent textComponent, OWLModel owlModel, Map smap) {
        String str = textComponent.getText();
        int pos = textComponent.getCaretPosition();
        int originalLength = str.length();
        String n = "";
        StringTokenizer tokenizer = new StringTokenizer(str, " \t\n,(){}[]", true);
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String symbol = (String)smap.get(token);
            if (symbol != null && (index += token.length()) < originalLength && (owlModel == null || owlModel.getRDFResource(token) == null)) {
                if ((n = String.valueOf(n) + symbol).length() >= pos) continue;
                pos = pos - token.length() + symbol.length();
                continue;
            }
            n = String.valueOf(n) + token;
        }
        if (!str.equals(n)) {
            textComponent.setText(n);
            textComponent.setCaretPosition(pos);
        }
    }

    private static class InsertAction
    extends AbstractAction {
        private char c;
        private JTextComponent textComponent;

        InsertAction(JTextComponent textComponent, char c) {
            this.c = c;
            this.textComponent = textComponent;
        }

        public void actionPerformed(ActionEvent e) {
            int offset = this.textComponent.getCaretPosition();
            try {
                this.textComponent.getDocument().insertString(offset, "" + this.c, null);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
    }
}

