/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.components.literaltable.LiteralTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LiteralTable
extends JTable {
    private JComboBox dataRangeComboBox;
    private JComboBox datatypeComboBox;
    private DefaultCellEditor defaultEditor;
    private JComboBox langComboBox;
    private LiteralTableModel tableModel;
    private JTextField textField;

    public LiteralTable(RDFProperty predicate) {
        this.tableModel = new LiteralTableModel(predicate);
        this.setModel(this.tableModel);
        this.setColumnWidth(0, 200);
        this.setColumnWidth(1, 100);
        this.textField = new JTextField();
        OWLUI.addCopyPastePopup(this.textField);
        this.defaultEditor = new DefaultCellEditor(this.textField);
        this.setDefaultEditor(Object.class, this.defaultEditor);
        this.dataRangeComboBox = new JComboBox();
        OWLModel owlModel = predicate.getOWLModel();
        this.datatypeComboBox = ComponentUtil.createDatatypeComboBox(owlModel);
        this.langComboBox = ComponentUtil.createLanguageComboBox(owlModel, null);
        TableColumn typeColumn = this.getColumnModel().getColumn(1);
        typeColumn.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof RDFSDatatype) {
                    value = ((RDFSDatatype)value).getLocalName();
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        TableColumn valueColumn = this.getColumnModel().getColumn(0);
        valueColumn.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.updateCellEditor();
    }

    public void editCell(Object value) {
        int row = this.tableModel.getRow(value);
        this.editCell(row);
    }

    public void editCell(int row) {
        if (row >= 0 && row < this.tableModel.getRowCount()) {
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
            this.editCellAt(row, 0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LiteralTable.this.textField.requestFocus();
                }
            });
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        RDFResource resource;
        RDFResource range;
        if (column == 0 && (range = (resource = this.tableModel.getSubject()).getAllValuesFromOnTypes(this.tableModel.getPredicate())) instanceof OWLDataRange) {
            OWLDataRange dataRange = (OWLDataRange)range;
            Object[] values = dataRange.getOneOfValues().toArray();
            this.dataRangeComboBox.setModel(new DefaultComboBoxModel<Object>(values));
            return new DefaultCellEditor(this.dataRangeComboBox);
        }
        return super.getCellEditor(row, column);
    }

    public LiteralTableModel getTableModel() {
        return this.tableModel;
    }

    private void setColumnWidth(int column, int width) {
        TableColumn col = this.getColumnModel().getColumn(column);
        col.setPreferredWidth(width);
    }

    public void setSelectedRow(Object value) {
        int row = this.tableModel.getRow(value);
        if (row >= 0) {
            this.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    public void setSubject(RDFResource subject) {
        this.tableModel.setSubject(subject);
        this.updateCellEditor();
    }

    public void stopEditing() {
        TableColumn typeColumn = this.getColumnModel().getColumn(1);
        typeColumn.getCellEditor().stopCellEditing();
        this.defaultEditor.stopCellEditing();
    }

    private void updateCellEditor() {
        TableColumn typeColumn = this.getColumnModel().getColumn(1);
        if (this.tableModel.isStringProperty()) {
            typeColumn.setCellEditor(new DefaultCellEditor(this.langComboBox));
        } else {
            typeColumn.setCellEditor(new DefaultCellEditor(this.datatypeComboBox));
        }
    }
}

