/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OWLDomainTableModel
extends AbstractTableModel
implements Disposable {
    private int COL_CLASS = 0;
    private List clses = new ArrayList();
    private RDFProperty property;
    private PropertyListener propertyListener = new PropertyAdapter(){

        public void unionDomainClassAdded(RDFProperty property, RDFSClass rdfsClass) {
            OWLDomainTableModel.this.refill();
        }

        public void unionDomainClassRemoved(RDFProperty property, RDFSClass rdfsClass) {
            OWLDomainTableModel.this.refill();
        }
    };

    public OWLDomainTableModel(RDFProperty property) {
        this.property = property;
        if (property != null) {
            this.fill();
            property.addPropertyListener(this.propertyListener);
        }
    }

    private boolean containsSubclassOf(Cls cls) {
        for (Cls cls1 : this.clses) {
            if (!cls1.hasSuperclass(cls)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
        }
    }

    private void fill() {
        Slot domainSlot = this.property.getOWLModel().getSlot(":DIRECT-DOMAIN");
        List localDomain = this.property.getDirectOwnSlotValues(domainSlot);
        if (localDomain.isEmpty()) {
            for (Slot superSlot : this.property.getSuperproperties(true)) {
                for (Cls cls : superSlot.getDirectOwnSlotValues(domainSlot)) {
                    if (!(cls instanceof RDFSClass) || this.clses.contains(cls) || this.containsSubclassOf(cls)) continue;
                    this.clses.add(cls);
                }
            }
        } else {
            for (Cls cls : localDomain) {
                if (!(cls instanceof RDFSClass)) continue;
                this.clses.add(cls);
            }
        }
    }

    RDFSClass getCls(int row) {
        return (RDFSClass)this.clses.get(row);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == this.COL_CLASS) {
            return Frame.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.clses.size();
    }

    public RDFProperty getSlot() {
        return this.property;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == this.COL_CLASS) {
            return this.getCls(rowIndex);
        }
        return null;
    }

    public boolean isInherited(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            Slot domainSlot;
            RDFProperty property = this.getSlot();
            List domain = property.getDirectOwnSlotValues(domainSlot = property.getOWLModel().getSlot(":DIRECT-DOMAIN"));
            return !domain.contains(cls);
        }
        return false;
    }

    private void refill() {
        this.clses.clear();
        this.fill();
        this.fireTableDataChanged();
    }

    public void setSlot(RDFProperty newProperty) {
        this.dispose();
        this.property = newProperty;
        this.clses.clear();
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
            this.fill();
        }
        this.fireTableDataChanged();
    }
}

