/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;

public class XSDAbstractDateTimeType
extends XSDDatatype {
    public static final short YEAR_MASK = 1;
    public static final short MONTH_MASK = 2;
    public static final short DAY_MASK = 4;
    public static final short TIME_MASK = 8;
    public static final short FULL_MASK = 15;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;

    public XSDAbstractDateTimeType(String string) {
        super(string);
    }

    public boolean isEqual(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        return literalLabel.getValue().equals(literalLabel2.getValue());
    }

    protected void getTime(String string, int n, int n2, int[] nArray, int[] nArray2) throws RuntimeException {
        int n4 = n + 2;
        nArray[3] = this.parseInt(string, n, n4);
        if (string.charAt(n4++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        n = n4;
        nArray[4] = this.parseInt(string, n, n4 += 2);
        if (string.charAt(n4++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        n = n4;
        nArray[5] = this.parseInt(string, n, n4 += 2);
        if (n4 == n2) {
            return;
        }
        n = n4;
        int n5 = string.charAt(n) == '.' ? n : -1;
        int n6 = this.findUTCSign(string, n, n2);
        if (n5 != -1) {
            n = n6 < 0 ? n2 : n6;
            nArray[6] = this.parseInt(string, n5 + 1, n);
        }
        if (n6 > 0) {
            if (n != n6) {
                throw new RuntimeException("Error in parsing time zone");
            }
            this.getTimeZone(string, nArray, n6, n2, nArray2);
        } else if (n != n2) {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int getDate(String string, int n, int n2, int[] nArray) throws RuntimeException {
        n = this.getYearMonth(string, n, n2, nArray);
        if (string.charAt(n++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int n4 = n + 2;
        nArray[2] = this.parseInt(string, n, n4);
        return n4;
    }

    protected int getYearMonth(String string, int n, int n2, int[] nArray) throws RuntimeException {
        int n4;
        if (string.charAt(0) == '-') {
            ++n;
        }
        if ((n4 = this.indexOf(string, n, n2, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int n5 = n4 - n;
        if (n5 < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (n5 > 4 && string.charAt(n) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        nArray[0] = this.parseIntYear(string, n4);
        if (string.charAt(n4) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        n = ++n4;
        n4 = n + 2;
        nArray[1] = this.parseInt(string, n, n4);
        return n4;
    }

    protected void parseTimeZone(String string, int n, int n2, int[] nArray, int[] nArray2) throws RuntimeException {
        if (n < n2) {
            int n4 = this.findUTCSign(string, n, n2);
            if (n4 < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(string, nArray, n4, n2, nArray2);
        }
    }

    protected void getTimeZone(String string, int[] nArray, int n, int n2, int[] nArray2) throws RuntimeException {
        nArray[7] = string.charAt(n);
        if (string.charAt(n) == 'Z') {
            if (n2 > ++n) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (n <= n2 - 6) {
            int n4 = ++n + 2;
            nArray2[0] = this.parseInt(string, n, n4);
            if (string.charAt(n4++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            nArray2[1] = this.parseInt(string, n4, n4 + 2);
            if (n4 + 2 != n2) {
                throw new RuntimeException("Error in parsing time zone");
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int indexOf(String string, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final int getDigit(char c) {
        return XSDAbstractDateTimeType.isDigit(c) ? c - 48 : -1;
    }

    protected int findUTCSign(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != 'Z' && c != '+' && c != '-') continue;
            return i;
        }
        return -1;
    }

    protected int parseInt(String string, int n, int n2) throws NumberFormatException {
        int n4 = 10;
        int n5 = 0;
        int n6 = 0;
        int n7 = -2147483647;
        int n8 = n7 / n4;
        int n9 = n;
        do {
            if ((n6 = XSDAbstractDateTimeType.getDigit(string.charAt(n9))) < 0) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if (n5 < n8) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if ((n5 *= n4) < n7 + n6) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            n5 -= n6;
        } while (++n9 < n2);
        return -n5;
    }

    protected int parseIntYear(String string, int n) {
        int n2;
        int n4 = 10;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        if (string.charAt(0) == '-') {
            bl = true;
            n2 = Integer.MIN_VALUE;
            ++n6;
        } else {
            n2 = -2147483647;
        }
        int n8 = n2 / n4;
        while (n6 < n) {
            if ((n7 = XSDAbstractDateTimeType.getDigit(string.charAt(n6++))) < 0) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if (n5 < n8) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if ((n5 *= n4) < n2 + n7) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            n5 -= n7;
        }
        if (bl) {
            if (n6 > 1) {
                return n5;
            }
            throw new NumberFormatException("'" + string.toString() + "' has wrong format");
        }
        return -n5;
    }

    public String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(25);
        this.append(stringBuffer, nArray[0], 4);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[1], 2);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[2], 2);
        stringBuffer.append('T');
        this.append(stringBuffer, nArray[3], 2);
        stringBuffer.append(':');
        this.append(stringBuffer, nArray[4], 2);
        stringBuffer.append(':');
        this.append(stringBuffer, nArray[5], 2);
        stringBuffer.append('.');
        stringBuffer.append(nArray[6]);
        this.append(stringBuffer, (char)nArray[7], 0);
        return stringBuffer.toString();
    }

    protected void append(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        if (n2 == 4) {
            if (n < 10) {
                stringBuffer.append("000");
            } else if (n < 100) {
                stringBuffer.append("00");
            } else if (n < 1000) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
        } else if (n2 == 2) {
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
        } else if (n != 0) {
            stringBuffer.append((char)n);
        }
    }
}

