/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBPropDatabase;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnection
implements IDBConnection {
    protected Connection m_connection;
    protected String m_url;
    protected String m_user;
    protected String m_password;
    protected String m_databaseType = null;
    protected IRDBDriver m_driver = null;

    public DBConnection(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public DBConnection(String string, String string2, String string3, String string4) {
        this.m_url = string;
        this.m_user = string2;
        this.m_password = string3;
        this.setDatabaseType(string4);
    }

    public DBConnection(Connection connection) {
        this(connection, null);
    }

    public DBConnection(Connection connection, String string) {
        this.m_connection = connection;
        this.setDatabaseType(string);
    }

    public Connection getConnection() throws SQLException {
        if (this.m_connection == null && this.m_url != null) {
            this.m_connection = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
            this.m_connection.setAutoCommit(true);
        }
        return this.m_connection;
    }

    public void close() throws SQLException {
        if (this.m_driver != null) {
            this.m_driver.close();
            this.m_driver = null;
        }
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    public void cleanDB() throws SQLException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        this.m_driver.cleanDB();
    }

    public boolean isFormatOK() {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        return this.m_driver.isDBFormatOK();
    }

    public void setDatabaseProperties(Model model) throws RDFRDBException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        this.m_driver.setDatabaseProperties(model.getGraph());
    }

    public Model getDatabaseProperties() throws RDFRDBException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        Model model = ModelFactory.createDefaultModel();
        DBConnection.copySpecializedGraphToModel(this.m_driver.getSystemSpecializedGraph(true), model, Triple.createMatch(null, null, null));
        return model;
    }

    public Model getDefaultModelProperties() throws RDFRDBException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        DBPropGraph dBPropGraph = this.m_driver.getDefaultModelProperties();
        Model model = ModelFactory.createDefaultModel();
        DBConnection.copySpecializedGraphToModel(this.m_driver.getSystemSpecializedGraph(true), model, Triple.createMatch(dBPropGraph.getNode(), null, null));
        return model;
    }

    public ExtendedIterator getAllModelNames() throws RDFRDBException {
        ExtendedIterator extendedIterator;
        SpecializedGraph specializedGraph;
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        if ((specializedGraph = this.m_driver.getSystemSpecializedGraph(false)) == null) {
            extendedIterator = new ResultSetIterator();
        } else {
            DBPropDatabase dBPropDatabase = new DBPropDatabase(specializedGraph);
            extendedIterator = dBPropDatabase.getAllGraphNames();
        }
        return extendedIterator;
    }

    public boolean containsModel(String string) throws RDFRDBException {
        SpecializedGraph specializedGraph;
        boolean bl = false;
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        if ((specializedGraph = this.m_driver.getSystemSpecializedGraph(false)) != null) {
            DBPropGraph dBPropGraph = DBPropGraph.findPropGraphByName(specializedGraph, string);
            bl = dBPropGraph == null ? false : dBPropGraph.isDBPropGraphOk(string);
        }
        return bl;
    }

    public boolean containsDefaultModel() throws RDFRDBException {
        return this.containsModel("DEFAULT");
    }

    static void copySpecializedGraphToModel(SpecializedGraph specializedGraph, Model model, TripleMatch tripleMatch) throws RDFRDBException {
        Graph graph = model.getGraph();
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        ExtendedIterator extendedIterator = specializedGraph.find(tripleMatch, completionFlag);
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
        extendedIterator.close();
    }

    public void setDatabaseType(String string) {
        if (string != null) {
            this.m_databaseType = string.compareToIgnoreCase("mysql") == 0 ? "MySQL" : string;
        }
    }

    public String getDatabaseType() {
        return this.m_databaseType;
    }

    public IRDBDriver getDriver() throws RDFRDBException {
        try {
            if (this.m_connection == null) {
                this.getConnection();
            }
            if (this.m_driver == null) {
                if (this.m_databaseType == null) {
                    throw new RDFRDBException("Error - attempt to call DBConnection.getDriver before setting the database type");
                }
                this.m_driver = (IRDBDriver)Class.forName("com.hp.hpl.jena.db.impl.Driver_" + this.m_databaseType).newInstance();
                this.m_driver.setConnection(this);
            }
        }
        catch (Exception exception) {
            throw new RDFRDBException("Failure to instantiate DB Driver:" + this.m_databaseType + " " + exception.toString());
        }
        return this.m_driver;
    }

    public void setDriver(IRDBDriver iRDBDriver) {
        this.m_driver = iRDBDriver;
    }

    public IRDBDriver getDriver(String string, String string2) throws RDFRDBException {
        this.setDatabaseType(string2);
        return this.getDriver();
    }
}

