/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBBulkUpdateHandler;
import com.hp.hpl.jena.db.impl.DBPrefixMappingImpl;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.DBReifier;
import com.hp.hpl.jena.db.impl.DBTransactionHandler;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphRDB
extends GraphBase
implements Graph {
    public static final String DEFAULT = "DEFAULT";
    protected IRDBDriver m_driver = null;
    protected DBPropGraph m_properties = null;
    protected DBPrefixMappingImpl m_prefixMapping = null;
    protected List m_specializedGraphs = null;
    protected List m_specializedGraphReifiers = null;
    protected Reifier m_reifier = null;
    protected int m_reificationBehaviour = 0;
    public static final int OPTIMIZE_ALL_REIFICATIONS_AND_HIDE_NOTHING = 1;
    public static final int OPTIMIZE_AND_HIDE_FULL_AND_PARTIAL_REIFICATIONS = 2;
    public static final int OPTIMIZE_AND_HIDE_ONLY_FULL_REIFICATIONS = 3;
    private QueryHandler q = null;

    public static int styleRDB(ReificationStyle reificationStyle) {
        if (reificationStyle == ReificationStyle.Standard) {
            return 1;
        }
        if (reificationStyle == ReificationStyle.Convenient) {
            return 2;
        }
        if (reificationStyle == ReificationStyle.Minimal) {
            return 3;
        }
        throw new JenaException("unsupported reification style");
    }

    public static ReificationStyle styleRDB(int n) {
        if (n == 1) {
            return ReificationStyle.Standard;
        }
        if (n == 2) {
            return ReificationStyle.Convenient;
        }
        if (n == 3) {
            return ReificationStyle.Minimal;
        }
        throw new JenaException("unsupported reification behaviour");
    }

    public GraphRDB(IDBConnection iDBConnection, String string, Graph graph, boolean bl) {
        this(iDBConnection, string, graph, 2, bl);
    }

    public GraphRDB(IDBConnection iDBConnection, String string, Graph graph, int n, boolean bl) {
        super(GraphRDB.styleRDB(n));
        this.m_reificationBehaviour = n;
        if (string == null) {
            string = DEFAULT;
        } else if (string.equals(DEFAULT)) {
            throw new JenaException("The model name \"DEFAULT\" is reserved.");
        }
        this.m_driver = iDBConnection.getDriver();
        SpecializedGraph specializedGraph = this.m_driver.getSystemSpecializedGraph(true);
        this.m_properties = DBPropGraph.findPropGraphByName(specializedGraph, string);
        if (this.m_properties != null) {
            if (bl) {
                throw new AlreadyExistsException(string);
            }
            if (graph != null) {
                throw new RDFRDBException("Error: attempt to change a graph's properties after it has been used.");
            }
            this.m_specializedGraphs = this.m_driver.recreateSpecializedGraphs(this.m_properties);
        } else {
            if (!bl) {
                throw new DoesNotExistException(string);
            }
            if (graph == null) {
                throw new RDFRDBException("Error: requested properties is null");
            }
            this.m_specializedGraphs = this.m_driver.createSpecializedGraphs(string, graph);
            this.m_properties = DBPropGraph.findPropGraphByName(specializedGraph, string);
            if (this.m_properties == null) {
                throw new RDFRDBException("Graph properties not found after creating graph.");
            }
        }
        this.m_specializedGraphReifiers = new ArrayList();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SpecializedGraphReifier)) continue;
            this.m_specializedGraphReifiers.add(e);
        }
    }

    public Node getNode() {
        if (this.m_properties == null) {
            throw new RDFRDBException("Error - attempt to call getNode() on a GraphRDB that has already been removed");
        }
        return this.m_properties.getNode();
    }

    public ExtendedIterator getPropertyTriples() {
        if (this.m_properties == null) {
            throw new RDFRDBException("Error - attempt to call getPropertyTriples on a GraphRDB that has been removed.");
        }
        return this.m_properties.listTriples();
    }

    protected boolean isOpen() {
        return this.m_specializedGraphs != null;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new ClosedException("GraphRDB", this);
        }
    }

    public void performAdd(Triple triple) {
        this.checkOpen();
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            specializedGraph.add(triple, completionFlag);
            if (!completionFlag.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.add(Triple) failed to find a suitable store for the triple:" + triple.toString());
    }

    public void add(List list) {
        this.checkOpen();
        ArrayList arrayList = new ArrayList(list);
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            specializedGraph.add(arrayList, completionFlag);
            if (!completionFlag.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.add(List) failed to find a suitable store for at least one triple:" + list.get(0).toString());
    }

    public void performDelete(Triple triple) {
        this.checkOpen();
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            specializedGraph.delete(triple, completionFlag);
            if (!completionFlag.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.delete(Triple) failed to find a suitable store for the triple:" + triple.toString());
    }

    public void delete(List list) {
        this.checkOpen();
        ArrayList arrayList = new ArrayList(list);
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            specializedGraph.delete(arrayList, completionFlag);
            if (!completionFlag.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.delete(Triple) failed to find a suitable store for at least one triple:" + list.get(0).toString());
    }

    public int graphBaseSize() {
        this.checkOpen();
        int n = 0;
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && (this.m_reificationBehaviour == 3 || this.m_reificationBehaviour == 2)) continue;
            n += specializedGraph.tripleCount();
        }
        return n;
    }

    public boolean graphBaseContains(Triple triple) {
        this.checkOpen();
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && (this.m_reificationBehaviour == 3 || this.m_reificationBehaviour == 2) || !(bl = specializedGraph.contains(triple, completionFlag)) && !completionFlag.isDone()) continue;
            return bl;
        }
        return false;
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        this.checkOpen();
        ExtendedIterator extendedIterator = NullIterator.instance;
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        Iterator iterator = this.m_specializedGraphs.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
            if (specializedGraph instanceof SpecializedGraphReifier && (this.m_reificationBehaviour == 3 || this.m_reificationBehaviour == 2)) continue;
            ExtendedIterator extendedIterator2 = specializedGraph.find(tripleMatch, completionFlag);
            extendedIterator = extendedIterator.andThen(extendedIterator2);
            if (!completionFlag.isDone()) continue;
            break;
        }
        return SimpleEventManager.notifyingRemove(this, extendedIterator);
    }

    public ExtendedIterator reifierTriples(TripleMatch tripleMatch) {
        return NullIterator.instance;
    }

    public int reifierSize() {
        return 0;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return new DBBulkUpdateHandler(this);
    }

    public Reifier getReifier() {
        if (this.m_reifier == null) {
            this.m_reifier = new DBReifier(this, this.style, this.m_specializedGraphReifiers, this.m_specializedGraphReifiers);
        }
        return this.m_reifier;
    }

    public PrefixMapping getPrefixMapping() {
        if (this.m_prefixMapping == null) {
            this.m_prefixMapping = new DBPrefixMappingImpl(this.m_properties);
        }
        return this.m_prefixMapping;
    }

    public TransactionHandler getTransactionHandler() {
        return new DBTransactionHandler(this.m_driver, this);
    }

    public synchronized void close() {
        if (this.m_specializedGraphs != null) {
            Iterator iterator = this.m_specializedGraphs.iterator();
            while (iterator.hasNext()) {
                SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
                specializedGraph.close();
            }
            this.m_specializedGraphs = null;
        }
    }

    public synchronized void remove() {
        this.checkOpen();
        this.m_driver.removeSpecializedGraphs(this.m_properties, this.m_specializedGraphs);
        this.m_properties = null;
        this.m_specializedGraphs = null;
    }

    public IDBConnection getConnection() {
        if (this.m_driver == null) {
            return null;
        }
        return this.m_driver.getConnection();
    }

    public int reificationBehavior() {
        return this.m_reificationBehaviour;
    }

    public Iterator getSpecializedGraphs() {
        return this.m_specializedGraphs.iterator();
    }

    public QueryHandler queryHandler() {
        if (this.q == null) {
            this.q = new DBQueryHandler(this);
        }
        return this.q;
    }

    public boolean getDoDuplicateCheck() {
        return this.m_driver.getDoDuplicateCheck();
    }

    public void setDoDuplicateCheck(boolean bl) {
        boolean bl2;
        this.m_driver.setDoDuplicateCheck(bl);
        boolean bl3 = bl2 = !bl;
        if (this.isOpen()) {
            Iterator iterator = this.m_specializedGraphs.iterator();
            while (iterator.hasNext()) {
                SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
                specializedGraph.getPSet().setSkipDuplicateCheck(bl2);
            }
        }
    }
}

