/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.test.AbstractTestQuery1;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestQuery1
extends AbstractTestQuery1 {
    private IDBConnection theConnection;
    private int count = 0;
    private List graphs;

    public TestQuery1(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQuery1.class);
    }

    public void setUp() throws Exception {
        this.theConnection = TestConnection.makeTestConnection();
        this.graphs = new ArrayList();
        super.setUp();
    }

    public void tearDown() throws Exception {
        this.removeGraphs();
        this.theConnection.close();
        super.tearDown();
    }

    private void removeGraphs() {
        for (int i = 0; i < this.graphs.size(); ++i) {
            ((GraphRDB)this.graphs.get(i)).remove();
        }
    }

    public Graph getGraph() {
        return this.getGraph(ReificationStyle.Minimal);
    }

    public Graph getGraph(ReificationStyle reificationStyle) {
        String string = "jena-test-rdb-TestQuery1-" + this.count++;
        if (this.theConnection.containsModel(string)) {
            this.makeGraph(string, false, reificationStyle).remove();
        }
        GraphRDB graphRDB = this.makeGraph(string, true, reificationStyle);
        this.graphs.add(graphRDB);
        return graphRDB;
    }

    protected GraphRDB makeGraph(String string, boolean bl, ReificationStyle reificationStyle) {
        return new GraphRDB(this.theConnection, string, this.theConnection.getDefaultModelProperties().getGraph(), GraphRDB.styleRDB(reificationStyle), bl);
    }
}

