/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.FragmentTripleIterator;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleReifierTripleMap
implements ReifierTripleMap {
    protected Map inverseMap = CollectionFactory.createHashedMap();
    protected Map forwardMap = CollectionFactory.createHashedMap();

    public Triple getTriple(Node node) {
        return (Triple)this.forwardMap.get(node);
    }

    public boolean hasTriple(Triple triple) {
        return this.inverseMap.containsKey(triple);
    }

    public Triple putTriple(Node node, Triple triple) {
        this.forwardMap.put(node, triple);
        this.inversePut(triple, node);
        return triple;
    }

    public void removeTriple(Node node) {
        Object v = this.forwardMap.get(node);
        this.forwardMap.remove(node);
        if (v instanceof Triple) {
            this.inverseRemove((Triple)v, node);
        }
    }

    public void removeTriple(Node node, Triple triple) {
        this.forwardMap.remove(node);
        this.inverseRemove(triple, node);
    }

    public void removeTriple(Triple triple) {
        ExtendedIterator extendedIterator = this.tagIterator(triple);
        Set set = CollectionFactory.createHashedSet();
        while (extendedIterator.hasNext()) {
            set.add(extendedIterator.next());
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.removeTriple((Node)iterator.next());
        }
    }

    protected void inverseRemove(Triple triple, Node node) {
        Set set = (Set)this.inverseMap.get(triple);
        if (set != null) {
            set.remove(node);
            if (set.isEmpty()) {
                this.inverseMap.remove(triple);
            }
        }
    }

    protected void inversePut(Triple triple, Node node) {
        HashSet<Node> hashSet = (HashSet<Node>)this.inverseMap.get(triple);
        if (hashSet == null) {
            hashSet = new HashSet<Node>();
            this.inverseMap.put(triple, hashSet);
        }
        hashSet.add(node);
    }

    public ExtendedIterator tagIterator(Triple triple) {
        Set set = (Set)this.inverseMap.get(triple);
        return set == null ? NullIterator.instance : WrappedIterator.create(set.iterator());
    }

    protected ExtendedIterator allTriples(TripleMatch tripleMatch) {
        Triple triple = tripleMatch.asTriple();
        Node node = triple.getSubject();
        if (node.isConcrete()) {
            Triple triple2 = this.getTriple(node);
            return triple2 == null ? NullIterator.instance : SimpleReifierTripleMap.explodeTriple(triple, node, triple2);
        }
        Iterator iterator = this.forwardMap.entrySet().iterator();
        return new FragmentTripleIterator(triple, iterator){

            public void fill(GraphAdd graphAdd, Node node, Object object) {
                SimpleReifier.graphAddQuad(graphAdd, node, (Triple)object);
            }
        };
    }

    public static ExtendedIterator explodeTriple(Triple triple, Node node, Triple triple2) {
        GraphAddList graphAddList = new GraphAddList(triple);
        SimpleReifier.graphAddQuad(graphAddList, node, triple2);
        return WrappedIterator.create(graphAddList.iterator());
    }

    public Graph asGraph() {
        return new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                return SimpleReifierTripleMap.this.allTriples(tripleMatch);
            }
        };
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.allTriples(tripleMatch);
    }

    public int size() {
        return this.forwardMap.size() * 4;
    }

    public ExtendedIterator tagIterator() {
        return WrappedIterator.create(this.forwardMap.keySet().iterator());
    }
}

