/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import junit.framework.TestSuite;

public class TestIndividual
extends OntTestBase {
    public static TestSuite suite() {
        return new TestIndividual("TestIndividual");
    }

    public TestIndividual(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Individual.sameAs", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual individual = ontModel.createIndividual(ontClass);
                Individual individual2 = ontModel.createIndividual(ontClass);
                Individual individual3 = ontModel.createIndividual(ontClass);
                individual.addSameAs(individual2);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)individual.getCardinality(profile.SAME_AS()));
                1.assertEquals((String)"x should be the same as y", (Object)individual2, (Object)individual.getSameAs());
                1.assertTrue((String)"x should be the same as y", (boolean)individual.isSameAs(individual2));
                individual.addSameAs(individual3);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)individual.getCardinality(profile.SAME_AS()));
                this.iteratorTest(individual.listSameAs(), new Object[]{individual3, individual2});
                individual.setSameAs(individual3);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)individual.getCardinality(profile.SAME_AS()));
                1.assertEquals((String)"x should be same indiv. as z", (Object)individual3, (Object)individual.getSameAs());
                individual.removeSameAs(individual2);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)individual.getCardinality(profile.SAME_AS()));
                individual.removeSameAs(individual3);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)individual.getCardinality(profile.SAME_AS()));
            }
        }};
    }
}

