/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;

public class ARPOptions
implements ARPErrorNumbers {
    private static int[] defaultErrorMode = new int[400];
    private boolean embedding = false;
    private int[] errorMode = (int[])defaultErrorMode.clone();

    ARPOptions copy() {
        ARPOptions aRPOptions = new ARPOptions();
        aRPOptions.errorMode = (int[])this.errorMode.clone();
        aRPOptions.embedding = this.embedding;
        return aRPOptions;
    }

    int[] getErrorMode() {
        return this.errorMode;
    }

    public int setErrorMode(int n, int n2) {
        int n4 = this.errorMode[n];
        switch (n2) {
            case 0: 
            case 1: {
                if (n >= 200 && n != 202) break;
            }
            case 2: 
            case 3: {
                switch (n) {
                    default: 
                }
                this.errorMode[n] = n2;
            }
        }
        return n4;
    }

    public void setDefaultErrorMode() {
        this.errorMode = (int[])defaultErrorMode.clone();
    }

    public void setLaxErrorMode() {
        this.setDefaultErrorMode();
        for (int i = 100; i < 200; ++i) {
            this.setErrorMode(i, 0);
        }
        this.setErrorMode(112, 1);
    }

    public void setStrictErrorMode() {
        this.setStrictErrorMode(0);
    }

    public void setStrictErrorMode(int n) {
        int n2;
        this.setDefaultErrorMode();
        for (n2 = 1; n2 < 100; ++n2) {
            this.setErrorMode(n2, n);
        }
        n2 = 1;
        int n4 = 2;
        switch (n) {
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n4 = 3;
                n2 = 3;
            }
        }
        for (int i = 100; i < 200; ++i) {
            this.setErrorMode(i, n4);
        }
        this.setErrorMode(112, n2);
        this.setErrorMode(112, n2);
        this.setErrorMode(117, n2);
        this.setErrorMode(131, n2);
        this.setErrorMode(106, n2);
        this.setErrorMode(119, n);
        this.setErrorMode(114, n);
        this.setErrorMode(113, n2);
        this.setErrorMode(103, n2);
        this.setErrorMode(101, n2);
        this.setErrorMode(118, n);
        this.setErrorMode(126, n2);
        this.setErrorMode(4, n4);
    }

    public boolean setEmbedding(boolean bl) {
        boolean bl2 = this.embedding;
        this.embedding = bl;
        return bl2;
    }

    boolean getEmbedding() {
        return this.embedding;
    }

    static {
        for (int i = 0; i < defaultErrorMode.length; ++i) {
            ARPOptions.defaultErrorMode[i] = i / 100;
        }
    }
}

