/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.ARPOptions;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.CharacterModel;
import com.hp.hpl.jena.rdf.arp.ExceptionToken;
import com.hp.hpl.jena.rdf.arp.FatalParsingErrorException;
import com.hp.hpl.jena.rdf.arp.LexicalHandlerImpl;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.Warn;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import com.hp.hpl.jena.rdf.arp.XMLNullContext;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class XMLHandler
extends LexicalHandlerImpl
implements RDFParserConstants,
ARPErrorNumbers {
    boolean encodingProblems = false;
    private Map nodeIdUserData;
    XMLContext documentContext;
    TokenPipe pipe;
    Locator locator;
    static final String rdfns;
    static final String xmlns;
    static final Map rdfnames;
    static final Set knownRDFProperties;
    static final Set knownRDFTypes;
    static final Set knownBadRDFNames;
    private static String[] specialAtts;
    private static String[] specialNameSpaces;
    private static int[] specialAttValues;
    private ARPOptions options = new ARPOptions();
    private ARPHandlers handlers = new ARPHandlers();

    XMLHandler() {
    }

    public void startPrefixMapping(String string, String string2) {
        this.handlers.getNamespaceHandler().startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) {
        this.handlers.getNamespaceHandler().endPrefixMapping(string);
    }

    void userWarning(ParseException parseException) throws SAXException {
        this.handlers.getErrorHandler().warning(parseException.rootCause());
    }

    void userError(ParseException parseException) throws SAXException {
        if (parseException.getFatal()) {
            this.handlers.getErrorHandler().fatalError(parseException.rootCause());
        } else {
            this.handlers.getErrorHandler().error(parseException.rootCause());
        }
    }

    Locator getLocator() {
        return this.pipe == null ? null : this.pipe.getLocator();
    }

    StatementHandler getStatementHandler() {
        return this.handlers.getStatementHandler();
    }

    public ARPHandlers getHandlers() {
        return this.handlers;
    }

    ARPOptions getOptions() {
        return this.options;
    }

    void setOptionsWith(ARPOptions aRPOptions) {
        this.options = aRPOptions.copy();
    }

    void setHandlersWith(ARPHandlers aRPHandlers) {
        this.handlers = aRPHandlers.copy();
    }

    void warning(int n, String string) {
        try {
            switch (this.options.getErrorMode()[n]) {
                case 0: {
                    break;
                }
                case 1: {
                    this.handlers.getErrorHandler().warning(new ParseException(n, string));
                    break;
                }
                case 2: {
                    this.handlers.getErrorHandler().error(new ParseException(n, string));
                    break;
                }
                case 3: {
                    this.handlers.getErrorHandler().fatalError(new ParseException(n, string));
                }
            }
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void parseWarning(int n, Location location, String string) throws ParseException {
        this.parseWarning(n, location, string, null);
    }

    void parseWarning(int n, Location location, String string, SAXParseException sAXParseException) throws ParseException {
        int n2 = this.options.getErrorMode()[n];
        if (n2 == 0) {
            return;
        }
        ParseException parseException = new ParseException(n, location, string, sAXParseException);
        if (n2 == 3) {
            parseException.setFatal(true);
            n2 = 2;
        }
        if (n2 == 2) {
            throw parseException;
        }
        try {
            this.userWarning(parseException);
            return;
        }
        catch (ParseException parseException2) {
            if (parseException2 == parseException) {
                throw parseException2;
            }
            throw new WrappedException(parseException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void parseWarning(Warn warn) throws ParseException {
        this.parseWarning(warn.number, warn.location, warn.msg);
    }

    void putWarning(int n, Location location, String string) throws SAXParseException {
        this.pipe.putNextToken(new Warn(n, location, string));
    }

    void setUserData(String string, Object object) {
        this.nodeIdUserData.put(string, object);
    }

    Object getUserData(String string) {
        return this.nodeIdUserData.get(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void doSpecialAtt(int n, int n2, String string, BitSet bitSet, Attributes attributes, Location location) throws SAXException {
        bitSet.set(n);
        if (n2 == 25) {
            return;
        }
        this.pipe.putNextToken(new ARPQname(n2, location, string, null, attributes.getQName(n)));
        String string2 = attributes.getValue(n);
        if (n2 == 18) {
            if (string2.equals("Resource")) {
                this.pipe.putNextToken(new StrToken(22, location, string2));
            } else if (string2.equals("Collection")) {
                this.pipe.putNextToken(new StrToken(21, location, string2));
            } else if (string2.equals("daml:collection") && this.options.getErrorMode()[125] != 2) {
                this.pipe.putNextToken(new StrToken(20, location, string2));
                this.putWarning(4, location, "Illegal parseType: " + string2);
            } else {
                this.pipe.putNextToken(new StrToken(19, location, string2));
                if (!string2.equals("Literal")) {
                    this.putWarning(106, location, "Unknown parseType: " + string2);
                }
            }
        } else {
            this.pipe.putNextToken(new StrToken(11, location, string2));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        int n;
        Location location = new Location(this.locator);
        this.putElementQname(string, string2, string3, location);
        BitSet bitSet = new BitSet();
        for (n = 0; n < attributes.getLength(); ++n) {
            String string5 = attributes.getQName(n);
            if (!string5.startsWith("xmlns")) continue;
            string4 = "";
            if (!string5.equals("xmlns")) {
                if (string5.charAt(5) != ':') continue;
                string4 = string5.substring(6);
            }
            bitSet.set(n);
            this.pipe.putNextToken(new StrToken(26, location, string4));
            String string6 = attributes.getValue(n);
            this.pipe.putNextToken(new StrToken(11, location, string6));
            if (string6.startsWith(rdfns) && !string6.equals(rdfns)) {
                this.putWarning(127, location, "Namespace URI ref " + string6 + " may not be used in RDF/XML.");
            }
            if (!string6.startsWith(xmlns) || string6.equals(xmlns)) continue;
            this.putWarning(128, location, "Namespace URI ref " + string6 + " may not be used in RDF/XML.");
        }
        for (n = 0; n < specialAtts.length; ++n) {
            int n2 = attributes.getIndex(specialNameSpaces[n], specialAtts[n]);
            if (n2 != -1) {
                this.doSpecialAtt(n2, specialAttValues[n], specialNameSpaces[n], bitSet, attributes, location);
            }
            if (specialNameSpaces[n] != rdfns || (n2 = attributes.getIndex("", specialAtts[n])) == -1) continue;
            this.putWarning(101, location, "Unqualified use of rdf:" + attributes.getLocalName(n2) + " has been deprecated.");
            this.doSpecialAtt(n2, specialAttValues[n], "", bitSet, attributes, location);
        }
        for (n = 0; n < attributes.getLength(); ++n) {
            if (bitSet.get(n)) continue;
            String string7 = attributes.getURI(n);
            string4 = attributes.getQName(n);
            if (string4.length() >= 3 && string4.substring(0, 3).toLowerCase().equals("xml")) {
                this.putWarning(118, location, "XML attribute: " + attributes.getQName(n) + " is not known and is being discarded.");
                continue;
            }
            if (string7.equals("")) {
                this.putWarning(102, location, "Attribute: " + attributes.getLocalName(n) + ". Unqualified use is deprecated. Assuming namespace: " + string);
                string7 = string;
            }
            this.putAttributeQname(string7, attributes.getLocalName(n), string4, location);
            this.pipe.putNextToken(new StrToken(11, location, attributes.getValue(n)));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new Token(6, location));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(1, location, new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private boolean isMemberProperty(String string) {
        if (string.startsWith("_")) {
            String string2 = string.substring(1);
            if (string2.startsWith("-") || string2.startsWith("0")) {
                return false;
            }
            try {
                Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    new BigInteger(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException2) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isKnownRDFProperty(String string) {
        return knownRDFProperties.contains(string);
    }

    private void putElementQname(String string, String string2, String string3, Location location) throws SAXException {
        Warn warn = null;
        if (string.equals(rdfns)) {
            Integer n = (Integer)rdfnames.get(string2);
            if (n == null) {
                if (this.isMemberProperty(string2)) {
                    this.pipe.putNextToken(new ARPQname(17, location, string, string2, string3));
                    return;
                }
                if (!knownRDFTypes.contains(string2) && !this.isKnownRDFProperty(string2)) {
                    warn = knownBadRDFNames.contains(string2) ? new Warn(205, location, "Creating statement(s) for syntactic RDF element: '<rdf:" + string2 + "'.") : new Warn(113, location, "Creating statement(s) for unknown RDF element: '<rdf:" + string2 + "'.");
                }
            } else {
                this.pipe.putNextToken(new ARPQname(n, location, string, string2, string3));
                return;
            }
        }
        this.pipe.putNextToken(new ARPQname(15, location, string, string2, string3));
        if (warn != null) {
            this.pipe.putNextToken(warn);
        }
    }

    private void putAttributeQname(String string, String string2, String string3, Location location) throws SAXException {
        if (string.equals(rdfns)) {
            if (this.isMemberProperty(string2)) {
                this.pipe.putNextToken(new ARPQname(13, location, string, string2, string3));
                return;
            }
            if (!this.isKnownRDFProperty(string2)) {
                if (knownBadRDFNames.contains(string2)) {
                    this.putWarning(206, location, "Inappropriate or removed RDF attribute: 'rdf:" + string2 + "'.");
                } else {
                    this.putWarning(103, location, "Creating statement for unknown RDF property: 'rdf:" + string2 + "'.");
                }
            }
        }
        this.pipe.putNextToken(new ARPQname(12, location, string, string2, string3));
    }

    public void comment(char[] cArray, int n, int n2) throws SAXParseException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(3, location, new String(cArray, n, n2)));
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(2, location, string2 == null ? string : string + " " + string2));
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        this.saxError(209, sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.saxError(126, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.saxError(301, sAXParseException);
        throw new FatalParsingErrorException();
    }

    void generalError(int n, Exception exception) throws SAXParseException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new ExceptionToken(n, location, exception));
    }

    private void saxError(int n, SAXParseException sAXParseException) throws SAXParseException {
        Location location = new Location(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        this.pipe.putNextToken(new ExceptionToken(n, location, sAXParseException));
    }

    void endLocalScope(Object object) {
        if (this.handlers.getExtendedHandler() != ARPHandlers.nullScopeHandler && object != null && object instanceof ARPResource) {
            ARPResource aRPResource = (ARPResource)object;
            if (!aRPResource.isAnonymous()) {
                return;
            }
            if (!aRPResource.getHasBeenUsed()) {
                return;
            }
            if (aRPResource.hasNodeID()) {
                if (this.handlers.getExtendedHandler().discardNodesWithNodeID()) {
                    return;
                }
                String string = aRPResource.nodeID;
                if (!this.nodeIdUserData.containsKey(string)) {
                    this.nodeIdUserData.put(string, null);
                }
            } else {
                this.handlers.getExtendedHandler().endBNodeScope(aRPResource);
            }
        }
    }

    void endRDF() {
        this.handlers.getExtendedHandler().endRDF();
    }

    void startRDF() {
        this.handlers.getExtendedHandler().startRDF();
    }

    boolean ignoring(int n) {
        return this.options.getErrorMode()[n] == 0;
    }

    protected void initParse(String string) throws MalformedURIException {
        this.nodeIdUserData = new HashMap();
        if (string == null) {
            this.warning(5, "Base URI not specified for input file; local URI references will be in error.");
            this.documentContext = new XMLNullContext(this, 211);
        } else if (string.equals("")) {
            this.warning(5, "Base URI specified as \"\"; local URI references will not be resolved.");
            this.documentContext = new XMLNullContext(this, 130);
        } else {
            string = ParserSupport.truncateXMLBase(string);
            this.documentContext = new XMLContext(string);
        }
    }

    void endBnodeScope() {
        if (this.getHandlers().getExtendedHandler() != ARPHandlers.nullScopeHandler) {
            Iterator iterator = this.nodeIdUserData.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ARPResource aRPResource = new ARPResource(this);
                aRPResource.setNodeId(string);
                this.getHandlers().getExtendedHandler().endBNodeScope(aRPResource);
            }
        }
    }

    static {
        CharacterModel.isFullyNormalizedConstruct("make the linkage error happen early");
        rdfns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".intern();
        xmlns = "http://www.w3.org/XML/1998/namespace".intern();
        rdfnames = new HashMap();
        rdfnames.put("Description", new Integer(7));
        rdfnames.put("RDF", new Integer(5));
        rdfnames.put("li", new Integer(16));
        knownRDFProperties = new HashSet();
        knownRDFTypes = knownRDFProperties;
        knownRDFTypes.add("Bag");
        knownRDFTypes.add("Seq");
        knownRDFTypes.add("Alt");
        knownRDFTypes.add("List");
        knownRDFTypes.add("XMLLiteral");
        knownRDFTypes.add("Property");
        knownRDFProperties.add("type");
        knownRDFTypes.add("Statement");
        knownRDFProperties.add("subject");
        knownRDFProperties.add("predicate");
        knownRDFProperties.add("object");
        knownRDFProperties.add("value");
        knownRDFProperties.add("first");
        knownRDFProperties.add("rest");
        knownRDFProperties.add("nil");
        knownBadRDFNames = new HashSet();
        knownBadRDFNames.add("ID");
        knownBadRDFNames.add("about");
        knownBadRDFNames.add("aboutEach");
        knownBadRDFNames.add("aboutEachPrefix");
        knownBadRDFNames.add("resource");
        knownBadRDFNames.add("bagID");
        knownBadRDFNames.add("parseType");
        knownBadRDFNames.add("datatype");
        knownBadRDFNames.add("li");
        knownBadRDFNames.add("type");
        knownBadRDFNames.add("Description");
        knownBadRDFNames.add("nodeID");
        specialAtts = new String[]{"base", "lang", "space", "ID", "about", "nodeID", "resource", "parseType", "datatype", "type"};
        specialNameSpaces = new String[]{xmlns, xmlns, xmlns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns};
        specialAttValues = new int[]{27, 28, 25, 8, 9, 10, 23, 18, 24, 14};
    }
}

