/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.NTriple;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.test.ExceptionTests;
import com.hp.hpl.jena.rdf.arp.test.TestErrorMsg;
import com.hp.hpl.jena.rdf.arp.test.TestScope;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MoreTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    private static Log logger = LogFactory.getLog((Class)MoreTests.class);
    private int[] expected;

    public static Test suite() {
        TestSuite testSuite = new TestSuite("ARP Plus");
        testSuite.addTest(TestErrorMsg.suite());
        testSuite.addTest(TestScope.suite());
        testSuite.addTest(ExceptionTests.suite());
        testSuite.addTest((Test)new MoreTests("testIcu"));
        testSuite.addTest((Test)new MoreTests("testLatin1"));
        testSuite.addTest((Test)new MoreTests("testIcu2"));
        testSuite.addTest((Test)new MoreTests("testEncodingMismatch1"));
        testSuite.addTest((Test)new MoreTests("testEncodingMismatch2"));
        testSuite.addTest((Test)new MoreTests("testNullBaseParamOK"));
        testSuite.addTest((Test)new MoreTests("testNullBaseParamError"));
        testSuite.addTest((Test)new MoreTests("testEmptyBaseParamOK"));
        testSuite.addTest((Test)new MoreTests("testEmptyBaseParamError"));
        testSuite.addTest((Test)new MoreTests("testWineDefaultNS"));
        testSuite.addTest((Test)new MoreTests("testInterrupt"));
        testSuite.addTest((Test)new MoreTests("testToString"));
        return testSuite;
    }

    public MoreTests(String string) {
        super(string);
    }

    protected Model createMemModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testWineDefaultNS() throws IOException {
        this.testWineNS(this.createMemModel());
        this.testWineNS(ModelFactory.createOntologyModel());
    }

    private void testWineNS(Model model) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream("testing/arp/xmlns/wine.rdf");
        model.read(fileInputStream, "");
        ((InputStream)fileInputStream).close();
        MoreTests.assertEquals((String)"http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#", (String)model.getNsPrefixURI(""));
    }

    public void testLatin1() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/arp/i18n/latin1.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{134};
        rDFReader.read(model, fileInputStream, "http://example.org/");
        this.checkExpected();
    }

    public void testARPMacRoman() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/arp/i18n/macroman.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{132, 133};
        this.expected[Charset.isSupported((String)"MacRoman") ? 0 : 1] = 0;
        rDFReader.read(model, fileInputStream, "http://example.org/");
        this.checkExpected();
    }

    public void testARPMacArabic() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/arp/i18n/arabic-macarabic.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{132, 133};
        this.expected[Charset.isSupported((String)"MacArabic") ? 0 : 1] = 0;
        rDFReader.read(model, fileInputStream, "http://example.org/");
        this.checkExpected();
    }

    public void testEncodingMismatch1() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileReader fileReader = new FileReader("testing/wg/rdfms-syntax-incomplete/test001.rdf");
        if (fileReader.getEncoding().startsWith("UTF")) {
            System.err.println("WARNING: Encoding mismatch tests not executed on platform with default UTF encoding.");
            return;
        }
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{129};
        rDFReader.read(model, fileReader, "http://example.org/");
        this.checkExpected();
    }

    public void testIcu() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/arp/i18n/icubug.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{121};
        rDFReader.read(model, fileInputStream, "http://example.org/");
        fileInputStream.close();
        this.checkExpected();
    }

    public void testIcu2() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/arp/i18n/icubugtwo.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{131};
        rDFReader.read(model, fileInputStream, "http://example.org/");
        fileInputStream.close();
        this.checkExpected();
    }

    public void testToString() throws IOException, SAXException {
        String string = "<rdf:RDF xmlns:music=\"http://www.kanzaki.com/ns/music#\"   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"> <rdf:Description>   <music:performs rdf:nodeID=\"p1\"/> </rdf:Description> <rdf:Description rdf:nodeID=\"p1\">   <music:opus>op.26</music:opus> </rdf:Description> </rdf:RDF>";
        ARP aRP = new ARP();
        ToStringStatementHandler toStringStatementHandler = new ToStringStatementHandler();
        aRP.getHandlers().setStatementHandler(toStringStatementHandler);
        aRP.load(new StringReader(string), "http://www.example.com");
        MoreTests.assertEquals((String)toStringStatementHandler.subj, (String)toStringStatementHandler.obj);
    }

    public void testEncodingMismatch2() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileReader fileReader = new FileReader("testing/wg/rdf-charmod-literals/test001.rdf");
        if (fileReader.getEncoding().startsWith("UTF")) {
            return;
        }
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{129, 210};
        rDFReader.read(model, fileReader, "http://example.org/");
        this.checkExpected();
    }

    public void testNullBaseParamOK() throws IOException {
        Model model = this.createMemModel();
        Model model2 = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[0];
        rDFReader.read(model, fileInputStream, "http://example.org/");
        fileInputStream.close();
        fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.read(model2, fileInputStream, null);
        fileInputStream.close();
        MoreTests.assertTrue((String)"Base URI should have no effect.", (boolean)model.isIsomorphicWith(model2));
        this.checkExpected();
    }

    public void testNullBaseParamError() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{211};
        rDFReader.read(model, fileInputStream, null);
        fileInputStream.close();
        this.checkExpected();
    }

    public void testEmptyBaseParamOK() throws IOException {
        Model model = this.createMemModel();
        Model model2 = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[0];
        rDFReader.read(model, fileInputStream, "http://example.org/");
        fileInputStream.close();
        fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.read(model2, fileInputStream, "");
        fileInputStream.close();
        MoreTests.assertTrue((String)("Empty base URI should have no effect.[" + model2.toString() + "]"), (boolean)model.isIsomorphicWith(model2));
        this.checkExpected();
    }

    public void testEmptyBaseParamError() throws IOException {
        Model model = this.createMemModel();
        RDFReader rDFReader = model.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{130};
        rDFReader.read(model, fileInputStream, "");
        fileInputStream.close();
        Model model2 = this.createMemModel();
        model2.createResource("#foo").addProperty(RDF.value, "abc");
        MoreTests.assertTrue((String)("Empty base URI should produce relative URI.[" + model.toString() + "]"), (boolean)model.isIsomorphicWith(model2));
        this.checkExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterrupt() throws SAXException, IOException {
        ARP aRP = new ARP();
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/miscellaneous/consistent001.rdf");
        aRP.getHandlers().setStatementHandler(new StatementHandler(){
            int countDown = 10;

            public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
                if (this.countDown-- == 0) {
                    Thread.currentThread().interrupt();
                }
            }

            public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            }
        });
        try {
            aRP.load(fileInputStream);
            MoreTests.fail((String)"Thread was not interrupted.");
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (SAXParseException sAXParseException) {
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private void checkExpected() {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] == 0) continue;
            MoreTests.fail((String)("Expected error: " + JenaReader.errorCodeName(this.expected[i]) + " but it did not occur."));
        }
    }

    public void warning(Exception exception) {
        this.error(0, exception);
    }

    public void error(Exception exception) {
        this.error(1, exception);
    }

    public void fatalError(Exception exception) {
        this.error(2, exception);
    }

    private void error(int n, Exception exception) {
        if (exception instanceof ParseException) {
            int n2 = ((ParseException)exception).getErrorNumber();
            this.onError(n, n2);
        } else {
            MoreTests.fail((String)("Not expecting an Exception: " + exception.getMessage()));
        }
    }

    private void println(String string) {
        logger.error((Object)string);
    }

    void onError(int n, int n2) {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] != n2) continue;
            this.expected[i] = 0;
            return;
        }
        String string = "Parser reports unexpected " + WGTestSuite.errorLevelName[n] + ": " + JenaReader.errorCodeName(n2);
        this.println(string);
        MoreTests.fail((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tokenGarbage(String string) {
        try {
            Token.COUNT = true;
            Token.COUNTTEST = true;
            Token.reinitHighTide();
            NTriple.main(new String[]{"-t", string});
            MoreTests.assertTrue((String)("Too many tokens used: " + Token.highTide), (Token.highTide < 2000 ? 1 : 0) != 0);
        }
        finally {
            Token.COUNT = false;
            Token.COUNTTEST = false;
        }
    }

    public void testTokenGarbage1() {
        this.tokenGarbage("testing/ontology/owl/Wine/wine.owl");
    }

    public void testTokenGarbage2() {
        this.tokenGarbage("testing/arp/gc/someWordNet.rdf");
    }

    static class ToStringStatementHandler
    implements StatementHandler {
        String obj;
        String subj;

        ToStringStatementHandler() {
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            this.subj = aResource.toString();
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            this.obj = aResource3.toString();
        }
    }
}

