/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecCreatorByClassname;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.util.HashMap;
import java.util.Map;

public class ModelSpecCreatorRegistry {
    protected Map creators = new HashMap();
    public static final ModelSpecCreatorRegistry instance = new ModelSpecCreatorRegistry("etc/modelspec-config.n3", true);

    public ModelSpecCreatorRegistry() {
    }

    public ModelSpecCreatorRegistry(String string) {
        this(string, false);
    }

    public ModelSpecCreatorRegistry(String string, boolean bl) {
        this();
        this.addFromModelNamed(string, bl);
    }

    public static ModelSpecCreatorRegistry registryWith(Resource resource, ModelSpecCreator modelSpecCreator) {
        ModelSpecCreatorRegistry modelSpecCreatorRegistry = new ModelSpecCreatorRegistry();
        modelSpecCreatorRegistry.registerCreator(resource, modelSpecCreator);
        return modelSpecCreatorRegistry;
    }

    public ModelSpecCreator getCreator(Resource resource) {
        return (ModelSpecCreator)this.creators.get(resource);
    }

    public static ModelSpecCreator findCreator(Resource resource) {
        return instance.getCreator(resource);
    }

    public void registerCreator(Resource resource, ModelSpecCreator modelSpecCreator) {
        this.creators.put(resource, modelSpecCreator);
    }

    public static void register(Resource resource, ModelSpecCreator modelSpecCreator) {
        instance.registerCreator(resource, modelSpecCreator);
    }

    protected void addFromModelNamed(String string, boolean bl) {
        block3: {
            try {
                Model model = FileManager.get().loadModel(string);
                StmtIterator stmtIterator = model.listStatements(null, JenaModelSpec.typeCreatedBy, (RDFNode)null);
                while (stmtIterator.hasNext()) {
                    this.addFromStatement(stmtIterator.nextStatement());
                }
            }
            catch (NotFoundException notFoundException) {
                if (bl) break block3;
                throw notFoundException;
            }
        }
    }

    protected void addFromStatement(Statement statement) {
        this.registerCreator(statement.getSubject(), new ModelSpecCreatorByClassname(statement.getString()));
    }

    static {
        ModelSpecCreatorRegistry.register(JenaModelSpec.InfModelSpec, new InfSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.OntModelSpec, new OntSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.PlainModelSpec, new PlainSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.ModelSpec, new PlainSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.DefaultModelSpec, new PlainSpecCreator());
    }

    static class OntSpecCreator
    implements ModelSpecCreator {
        OntSpecCreator() {
        }

        public ModelSpec create(Resource resource, Model model) {
            return new OntModelSpec(resource, model);
        }
    }

    static class PlainSpecCreator
    implements ModelSpecCreator {
        PlainSpecCreator() {
        }

        public ModelSpec create(Resource resource, Model model) {
            return new PlainModelSpec(resource, model);
        }
    }

    static class InfSpecCreator
    implements ModelSpecCreator {
        InfSpecCreator() {
        }

        public ModelSpec create(Resource resource, Model model) {
            return new InfModelSpec(resource, model);
        }
    }
}

