/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConcurrency
extends TestSuite {
    static long SLEEP = 100L;
    static int threadCount = 0;
    static final Model model1 = ModelFactory.createDefaultModel();
    static final Model model2 = ModelFactory.createDefaultModel();

    public static TestSuite suite() {
        return new TestConcurrency();
    }

    public TestConcurrency() {
        super("Model concurrency control");
        this.addTest((Test)new Nesting("Lock nesting 1 - same model", model1, true, true, false));
        this.addTest((Test)new Nesting("Lock nesting 2 - same model", model1, false, false, false));
        this.addTest((Test)new Nesting("Lock nesting 3 - same model", model1, true, false, true));
        this.addTest((Test)new Nesting("Lock nesting 4 - same model", model1, false, true, false));
        this.addTest((Test)new Nesting("Lock nesting 1 - defifferent models", model1, true, model2, true, false));
        this.addTest((Test)new Nesting("Lock nesting 2 - defifferent models", model1, false, model2, false, false));
        this.addTest((Test)new Nesting("Lock nesting 3 - defifferent models", model1, true, model2, false, false));
        this.addTest((Test)new Nesting("Lock nesting 4 - defifferent models", model1, false, model2, true, false));
        this.addTest((Test)new Parallel("Parallel concurrency test"));
    }

    static class Parallel
    extends TestCase {
        int threadTotal = 10;
        volatile int writers = 0;

        Parallel(String string) {
            super(string);
        }

        protected void runTest() throws Throwable {
            int n;
            int n2;
            Model model = ModelFactory.createDefaultModel();
            Thread[] threadArray = new Thread[this.threadTotal];
            boolean bl = true;
            for (n2 = 0; n2 < this.threadTotal; ++n2) {
                String string = "T" + Integer.toString(++threadCount);
                threadArray[n2] = new Operation(model, bl);
                threadArray[n2].setName(string);
                threadArray[n2].start();
                bl = !bl;
            }
            n2 = 0;
            for (n = 0; n < this.threadTotal; ++n) {
                try {
                    threadArray[n].join(200L * SLEEP);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (n = 0; n < this.threadTotal; ++n) {
                if (threadArray[n].isAlive()) {
                    try {
                        threadArray[n].join(200L * SLEEP);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!threadArray[n].isAlive()) continue;
                System.out.println("Thread " + threadArray[n].getName() + " failed to finish");
                n2 = 1;
            }
            Parallel.assertTrue((String)"Some thread failed to finish", (n2 == 0 ? 1 : 0) != 0);
        }

        void doStuff(String string, boolean bl) {
            String string2 = Thread.currentThread().getName();
            try {
                Thread.sleep(SLEEP);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bl) {
                throw new RuntimeException(string);
            }
        }

        public void readOperation(boolean bl) {
            if (this.writers > 0) {
                System.err.println("Concurrency error: writers around!");
            }
            this.doStuff("read operation", false);
            if (this.writers > 0) {
                System.err.println("Concurrency error: writers around!");
            }
        }

        public void writeOperation(boolean bl) {
            ++this.writers;
            this.doStuff("write operation", false);
            --this.writers;
        }

        class Operation
        extends Thread {
            Model model;
            boolean readLock;

            Operation(Model model, boolean bl) {
                this.model = model;
                this.readLock = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = 0; i < 2; ++i) {
                    try {
                        this.model.enterCriticalSection(this.readLock);
                        if (this.readLock) {
                            Parallel.this.readOperation(false);
                            continue;
                        }
                        Parallel.this.writeOperation(false);
                        continue;
                    }
                    finally {
                        this.model.leaveCriticalSection();
                    }
                }
            }
        }
    }

    static class Nesting
    extends TestCase {
        Model outerModel;
        Model innerModel;
        boolean outerLock;
        boolean innerLock;
        boolean exceptionExpected;

        Nesting(String string, Model model, boolean bl, boolean bl2, boolean bl3) {
            this(string, model, bl, model, bl2, bl3);
        }

        Nesting(String string, Model model, boolean bl, Model model2, boolean bl2, boolean bl3) {
            super(string);
            this.outerModel = model;
            this.outerLock = bl;
            this.innerModel = model2;
            this.innerLock = bl2;
            this.exceptionExpected = bl3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws Throwable {
            boolean bl = false;
            try {
                this.outerModel.enterCriticalSection(this.outerLock);
                try {
                    try {
                        this.innerModel.enterCriticalSection(this.innerLock);
                    }
                    finally {
                        this.innerModel.leaveCriticalSection();
                    }
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            finally {
                this.outerModel.leaveCriticalSection();
            }
            if (this.exceptionExpected) {
                Nesting.assertTrue((String)"Failed to get expected lock promotion error", (boolean)bl);
            } else {
                Nesting.assertTrue((String)"Got unexpected lock promotion error", (!bl ? 1 : 0) != 0);
            }
        }
    }
}

