/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.Q_PatternLiteral;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Q_StringNoMatch
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    Q_PatternLiteral regex = null;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();
    private String printName = "strMatch";
    private String opSymbol = "!~";
    Pattern pattern = null;

    Q_StringNoMatch(int n) {
        super(n);
    }

    Q_StringNoMatch(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public NodeValue eval(Query query, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query, indexValues);
        String string = nodeValue.valueString();
        WorkingVar workingVar = new WorkingVar();
        boolean bl = this.matcher.contains(string, this.pattern);
        workingVar.setBoolean(!bl);
        return workingVar;
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (n == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringNoMatch: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
        if (!(this.right instanceof Q_PatternLiteral)) {
            throw new EvalFailureException("Q_StringNoMatch: Pattern error");
        }
        this.regex = (Q_PatternLiteral)this.right;
        try {
            this.pattern = this.compiler.compile(this.regex.patternString, this.regex.mask);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new EvalFailureException("Q_StringNoMatch: Pattern exception: " + (Object)((Object)malformedPatternException));
        }
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

