/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public abstract class BaseInfGraph
extends GraphBase
implements InfGraph {
    protected Reasoner reasoner;
    protected FGraph fdata;
    protected boolean recordDerivations;
    protected boolean isPrepared = false;

    public PrefixMapping getPrefixMapping() {
        return this.getRawGraph().getPrefixMapping();
    }

    public Reifier getReifier() {
        return this.getRawGraph().getReifier();
    }

    public BaseInfGraph(Graph graph, Reasoner reasoner) {
        this.fdata = new FGraph(graph);
        this.reasoner = reasoner;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            return this.getReasoner().getGraphCapabilities();
        }
        return this.capabilities;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new InfBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public TransactionHandler getTransactionHandler() {
        return new InfTransactionHandler(this);
    }

    protected void discardState() {
    }

    public Graph getRawGraph() {
        return this.fdata.getGraph();
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public void rebind(Graph graph) {
        this.fdata = new FGraph(graph);
        this.isPrepared = false;
    }

    public void rebind() {
        this.isPrepared = false;
    }

    public void reset() {
    }

    public void prepare() {
        this.isPrepared = true;
    }

    public Graph getDeductionsGraph() {
        return null;
    }

    public Node getGlobalProperty(Node node) {
        throw new ReasonerException("Global property not implemented: " + node);
    }

    public boolean testGlobalProperty(Node node) {
        Object object;
        Node node2 = this.getGlobalProperty(node);
        if (node2.isLiteral() && (object = node2.getLiteral().getValue()) instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ReasonerException("Global property test returned non-boolean value\nTest was: " + node + "\nResult was: " + node2);
    }

    public ValidityReport validate() {
        this.checkOpen();
        return new StandardValidityReport();
    }

    public ExtendedIterator find(Node node, Node node2, Node node3, Graph graph) {
        return this.cloneWithPremises(graph).find(node, node2, node3);
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        return this.graphBaseFind(tripleMatch.getMatchSubject(), tripleMatch.getMatchPredicate(), tripleMatch.getMatchObject());
    }

    public ExtendedIterator graphBaseFind(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), this.fdata);
    }

    public abstract ExtendedIterator findWithContinuation(TriplePattern var1, Finder var2);

    public ExtendedIterator find(TriplePattern triplePattern) {
        this.checkOpen();
        return this.findWithContinuation(triplePattern, this.fdata);
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public Iterator getDerivation(Triple triple) {
        return null;
    }

    public int graphBaseSize() {
        this.checkOpen();
        return this.fdata.getGraph().size();
    }

    public boolean isEmpty() {
        return this.fdata.getGraph().isEmpty();
    }

    public void close() {
        if (!this.closed) {
            this.fdata.getGraph().close();
            this.fdata = null;
            super.close();
        }
    }

    public synchronized void performAdd(Triple triple) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().add(triple);
    }

    public void performDelete(Triple triple) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().delete(triple);
    }

    public abstract Graph getSchemaGraph();

    public InfGraph cloneWithPremises(Graph graph) {
        return this.getReasoner().bindSchema(this.getSchemaGraph()).bind(new Union(this.getRawGraph(), graph));
    }

    public static class InfTransactionHandler
    extends TransactionHandlerBase
    implements TransactionHandler {
        protected final BaseInfGraph base;

        public InfTransactionHandler(BaseInfGraph baseInfGraph) {
            this.base = baseInfGraph;
        }

        public boolean transactionsSupported() {
            return this.getBaseHandler().transactionsSupported();
        }

        protected TransactionHandler getBaseHandler() {
            return this.base.getRawGraph().getTransactionHandler();
        }

        public void begin() {
            this.getBaseHandler().begin();
        }

        public void abort() {
            this.getBaseHandler().abort();
            this.base.rebind();
        }

        public void commit() {
            this.getBaseHandler().commit();
        }
    }

    static class InfBulkUpdateHandler
    extends SimpleBulkUpdateHandler {
        public InfBulkUpdateHandler(BaseInfGraph baseInfGraph) {
            super(baseInfGraph);
        }

        public void remove(Node node, Node node2, Node node3) {
            BaseInfGraph baseInfGraph = (BaseInfGraph)this.graph;
            baseInfGraph.getRawGraph().getBulkUpdateHandler().remove(node, node2, node3);
            baseInfGraph.discardState();
            baseInfGraph.rebind();
            this.manager.notifyEvent(this.graph, GraphEvents.remove(node, node2, node3));
        }

        public void removeAll() {
            BaseInfGraph baseInfGraph = (BaseInfGraph)this.graph;
            baseInfGraph.getRawGraph().getBulkUpdateHandler().removeAll();
            baseInfGraph.discardState();
            baseInfGraph.rebind();
            baseInfGraph.getEventManager().notifyEvent(baseInfGraph, GraphEvents.removeAll);
        }
    }

    public static class InfFindSafeCapabilities
    extends InfCapabilities {
        public boolean findContractSafe() {
            return true;
        }
    }

    public static class InfCapabilities
    extends AllCapabilities {
        public boolean sizeAccurate() {
            return false;
        }

        public boolean deleteAllowed(boolean bl) {
            return !bl;
        }

        public boolean iteratorRemoveAllowed() {
            return false;
        }

        public boolean findContractSafe() {
            return false;
        }
    }
}

