/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEClauseFilter;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRETE
extends TestCase {
    Node_RuleVariable x = new Node_RuleVariable("x", 0);
    Node_RuleVariable y = new Node_RuleVariable("y", 1);
    Node_RuleVariable z = new Node_RuleVariable("z", 2);
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node e = Node.createURI("e");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node n1 = Node.createURI("n1");
    Node n2 = Node.createURI("n2");
    Node n3 = Node.createURI("n3");
    Node n4 = Node.createURI("n4");
    Node res = Node.createURI("res");

    public TestRETE(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRETE.class);
    }

    public void testClauseFilter() {
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, this.x), new Triple(this.a, this.p, this.b), new Node[]{this.b, null, null});
        this.doTestClauseFilter(new TriplePattern(this.x, this.p, this.b), new Triple(this.a, this.p, this.b), new Node[]{this.a, null, null});
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, this.x), new Triple(this.b, this.p, this.a), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, this.x), new Triple(this.a, this.q, this.a), null);
        this.doTestClauseFilter(new TriplePattern(this.x, this.p, this.x), new Triple(this.a, this.p, this.a), new Node[]{this.a, null, null});
        this.doTestClauseFilter(new TriplePattern(this.x, this.p, this.x), new Triple(this.a, this.p, this.b), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.x, this.c})), new Triple(this.a, this.p, this.a), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, this.x), new Triple(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, this.c})), new Node[]{Functor.makeFunctorNode("f", new Node[]{this.b, this.c}), null, null});
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, Functor.makeFunctorNode("g", new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, this.c})), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, this.c})), new Node[]{this.b, null, null});
        this.doTestClauseFilter(new TriplePattern(this.x, this.p, Functor.makeFunctorNode("f", new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.a, this.c})), new Node[]{this.a, null, null});
        this.doTestClauseFilter(new TriplePattern(this.x, this.p, Functor.makeFunctorNode("f", new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, this.c})), null);
    }

    private void doTestClauseFilter(TriplePattern triplePattern, Triple triple, Node[] nodeArray) {
        RETETestNode rETETestNode = new RETETestNode();
        RETEClauseFilter rETEClauseFilter = RETEClauseFilter.compile(triplePattern, 3, new LinkedList());
        rETEClauseFilter.setContinuation(rETETestNode);
        rETEClauseFilter.fire(triple, true);
        if (nodeArray == null) {
            TestRETE.assertTrue((rETETestNode.firings == 0 ? 1 : 0) != 0);
        } else {
            TestRETE.assertTrue((rETETestNode.firings == 1 ? 1 : 0) != 0);
            TestRETE.assertTrue((boolean)rETETestNode.isAdd);
            TestRETE.assertEquals((Object)new BindingVector(nodeArray), (Object)rETETestNode.env);
        }
    }

    public void testRuleMatcher() {
        this.doRuleTest("[r1: (?a p ?b), (?b q ?c) -> (?a, q, ?c)][r2: (?a p ?b), (?b p ?c) -> (?a, p, ?c)][r3: (?a p ?a), (n1 p ?c), (n1, p, ?a) -> (?a, p, ?c)][r4: (n4 ?p ?a) -> (n4, ?a, ?p)]", new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4)}, new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4), new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3), new Triple(this.n4, this.n4, this.p)});
        this.doRuleTest("[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][axiom1: -> (n1 p n3)]", new Triple[0], new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3)});
        this.doRuleTest("[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][axiom1: -> (n1 p n3)]", new Triple[]{new Triple(this.n1, this.q, this.n4), new Triple(this.n1, this.q, this.n3)}, new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
        this.doRuleTest("[rule1: (?x p ?y), (?x q ?y) -> remove(0)]", new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode(1)), new Triple(this.n1, this.p, Util.makeIntNode(2)), new Triple(this.n1, this.q, Util.makeIntNode(2))}, new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode(1)), new Triple(this.n1, this.q, Util.makeIntNode(2))});
    }

    private void doRuleTest(String string, Triple[] tripleArray, Triple[] tripleArray2) {
        List list = Rule.parseRules(string);
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(null, new ArrayList(), null, new GraphMem());
        RETEEngine rETEEngine = new RETEEngine(basicForwardRuleInfGraph, list);
        basicForwardRuleInfGraph.prepare();
        rETEEngine.init(true, new FGraph(new GraphMem()));
        for (int i = 0; i < tripleArray.length; ++i) {
            rETEEngine.addTriple(tripleArray[i], true);
        }
        rETEEngine.runAll();
        TestUtil.assertIteratorValues(this, basicForwardRuleInfGraph.find(null, null, null), tripleArray2);
    }

    public void testRuleClone() {
        String string = "[testRule1: (a p ?x) (b p ?x) -> (n1 p ?x) ][testRule2: (?x q ?y) -> (?x p ?y)]";
        List list = Rule.parseRules(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.q, this.c));
        graphMem.add(new Triple(this.a, this.q, this.d));
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(this.b, this.q, this.c));
        GraphMem graphMem3 = new GraphMem();
        graphMem3.add(new Triple(this.b, this.q, this.d));
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        Reasoner reasoner = genericRuleReasoner.bindSchema(graphMem);
        InfGraph infGraph = reasoner.bind(graphMem2);
        InfGraph infGraph2 = reasoner.bind(graphMem3);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), new Triple[]{new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d), new Triple(this.b, this.p, this.c), new Triple(this.n1, this.p, this.c)});
        TestUtil.assertIteratorValues(this, infGraph2.find(null, this.p, null), new Triple[]{new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d), new Triple(this.b, this.p, this.d), new Triple(this.n1, this.p, this.d)});
    }

    protected static class RETETestNode
    implements RETESinkNode {
        BindingVector env;
        boolean isAdd;
        int firings = 0;

        protected RETETestNode() {
        }

        public void fire(BindingVector bindingVector, boolean bl) {
            ++this.firings;
            this.env = bindingVector;
            this.isAdd = bl;
        }

        public RETENode clone(Map map, RETERuleContext rETERuleContext) {
            return this;
        }
    }
}

