/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FormatterARQ;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterSPARQLalt
extends FormatterARQ {
    public FormatterSPARQLalt(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        super(indentedWriter, serializationContext);
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Element element) {
        FormatterSPARQLalt formatterSPARQLalt = new FormatterSPARQLalt(indentedWriter, serializationContext);
        formatterSPARQLalt.startVisit();
        element.visit(formatterSPARQLalt);
        formatterSPARQLalt.finishVisit();
    }

    public static String asString(Element element) {
        SerializationContext serializationContext = new SerializationContext(null, null, null);
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterSPARQLalt formatterSPARQLalt = new FormatterSPARQLalt(indentedLineBuffer.getIndentedWriter(), serializationContext);
        element.visit(formatterSPARQLalt);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementGroup elementGroup) {
        if (GROUP_UNNEST_ONE && elementGroup.getElements().size() == 1) {
            Element element = (Element)elementGroup.getElements().get(0);
            element.visit(this);
            return;
        }
        this.out.print("{");
        this.out.incIndent(2);
        int n = this.out.getRow();
        this.out.pad();
        boolean bl = true;
        ListIterator listIterator = elementGroup.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.out.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
        }
        this.out.decIndent(2);
        int n2 = this.out.getRow();
        if (n != n2) {
            this.out.newline();
            this.out.print("}");
        } else {
            this.out.print(" }");
        }
    }

    public void visit(ElementBasePattern elementBasePattern) {
        boolean bl = true;
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.out.newline();
            }
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
            bl = false;
        }
    }

    public void visit(ElementConstraints elementConstraints) {
        boolean bl = true;
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            if (!bl) {
                this.out.newline();
            }
            Constraint constraint = (Constraint)iterator.next();
            this.out.print("AND ");
            if (constraint instanceof Expr) {
                Expr expr = (Expr)constraint;
                FmtExprARQ fmtExprARQ = new FmtExprARQ(this.out, this.context);
                expr.visit(fmtExprARQ);
            } else {
                this.out.print(constraint.toString());
            }
            bl = false;
        }
    }

    public void visit(TemplateTriple templateTriple) {
        this.formatTriple(templateTriple.getTriple());
    }

    public void visit(TemplateGroup templateGroup) {
        boolean bl = true;
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            TemplateBase templateBase = (TemplateBase)iterator.next();
            templateBase.visit(this);
            this.out.newline();
            bl = false;
        }
    }

    private void formatTriple(Triple triple) {
        this.out.print("( ");
        this.out.print(this.slotToString(this.context, triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getObject()));
        this.out.print(" )");
    }

    private String slotToString(SerializationContext serializationContext, Node node) {
        return QueryPrintUtils.stringForNode(node, serializationContext.getPrefixMap());
    }
}

