/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.publish.uddi;

import java.util.List;
import java.util.Vector;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.binding.AccessPoint;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.TModelInstanceDetails;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UddiUtils {
    private UDDIProxy uddiProxy;
    private AuthToken authToken;

    public UddiUtils(UDDIProxy uddiProxy) {
        this.uddiProxy = uddiProxy;
    }

    public UddiUtils(UDDIProxy uddiProxy, AuthToken authToken) {
        this(uddiProxy);
        this.authToken = authToken;
    }

    public List<BusinessInfo> findBusinesses(String name, int maxNumber) throws UDDIException, TransportException {
        Vector<Name> businessNames = new Vector<Name>();
        businessNames.add(new Name(name));
        BusinessInfos businessInfos = this.uddiProxy.find_business(businessNames, null, null, null, null, null, maxNumber).getBusinessInfos();
        return businessInfos.getBusinessInfoVector();
    }

    public List<ServiceInfo> findServices(String businessKey, CategoryBag categoryBag, int maxNumber) throws UDDIException, TransportException {
        ServiceInfos serviceInfos = this.uddiProxy.find_service(businessKey, null, categoryBag, null, null, maxNumber).getServiceInfos();
        return serviceInfos.getServiceInfoVector();
    }

    public TModel findTModel(String name, CategoryBag categoryBag) throws UDDIException, TransportException {
        TModelInfos tModelInfos = this.uddiProxy.find_tModel(name, categoryBag, null, null, 1).getTModelInfos();
        if (tModelInfos.size() > 0) {
            return this.getTModel(tModelInfos.get(0).getTModelKey());
        }
        return null;
    }

    public TModel getTModel(String tModelKey) throws UDDIException, TransportException {
        return (TModel)this.uddiProxy.get_tModelDetail(tModelKey).getTModelVector().get(0);
    }

    public BusinessEntity getBusinessEntity(String businessKey) throws UDDIException, TransportException {
        return (BusinessEntity)this.uddiProxy.get_businessDetail(businessKey).getBusinessEntityVector().get(0);
    }

    public BusinessService getBusinessService(String serviceKey) throws UDDIException, TransportException {
        return (BusinessService)this.uddiProxy.get_serviceDetail(serviceKey).getBusinessServiceVector().get(0);
    }

    public BusinessEntity publishBusiness(String name, String description) throws TransportException, UDDIException {
        List<BusinessInfo> businessInfos = this.findBusinesses(name, 1);
        if (businessInfos.size() > 0) {
            return this.getBusinessEntity(businessInfos.get(0).getBusinessKey());
        }
        BusinessEntity business = new BusinessEntity();
        business.setDefaultName(new Name(name));
        business.setDefaultDescriptionString(description);
        Vector<BusinessEntity> businesses = new Vector<BusinessEntity>();
        businesses.add(business);
        BusinessDetail businessDetail = this.uddiProxy.save_business(this.authToken.getAuthInfoString(), businesses);
        return (BusinessEntity)businessDetail.getBusinessEntityVector().get(0);
    }

    public TModel publishTModel(String name, String description, String overviewUrl, CategoryBag categoryBag) throws UDDIException, TransportException {
        TModel tModel = this.findTModel(name, categoryBag);
        if (tModel != null) {
            return tModel;
        }
        tModel = new TModel();
        tModel.setName(name);
        tModel.setDefaultDescriptionString(description);
        tModel.setCategoryBag(categoryBag);
        OverviewDoc oDoc = new OverviewDoc();
        oDoc.setOverviewURL(overviewUrl);
        tModel.setOverviewDoc(oDoc);
        Vector<TModel> tModels = new Vector<TModel>();
        tModels.add(tModel);
        TModelDetail tModelDetail = this.uddiProxy.save_tModel(this.authToken.getAuthInfoString(), tModels);
        return (TModel)tModelDetail.getTModelVector().get(0);
    }

    public BindingTemplate publishBindingTemplate(AccessPoint accessPoint, String serviceKey, TModelInstanceDetails tModelInstanceDetails) throws TransportException, UDDIException {
        BindingTemplate bindingTemplate = new BindingTemplate();
        bindingTemplate.setServiceKey(serviceKey);
        bindingTemplate.setAccessPoint(accessPoint);
        bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
        Vector<BindingTemplate> bindingTemplates = new Vector<BindingTemplate>();
        bindingTemplates.add(bindingTemplate);
        BindingDetail bindingDetail = this.uddiProxy.save_binding(this.authToken.getAuthInfoString(), bindingTemplates);
        return (BindingTemplate)bindingDetail.getBindingTemplateVector().get(0);
    }

    public BusinessService publishService(String name, String description, String businessKey, CategoryBag categoryBag) throws TransportException, UDDIException {
        BusinessService businessService = new BusinessService();
        businessService.setDefaultName(new Name(name));
        businessService.setDefaultDescriptionString(description);
        businessService.setBusinessKey(businessKey);
        businessService.setCategoryBag(categoryBag);
        Vector<BusinessService> businessServices = new Vector<BusinessService>();
        businessServices.add(businessService);
        ServiceDetail serviceDetail = this.uddiProxy.save_service(this.authToken.getAuthInfoString(), businessServices);
        return (BusinessService)serviceDetail.getBusinessServiceVector().get(0);
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(AuthToken authToken) {
        this.authToken = authToken;
    }
}

