/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.ontology.tidy.impl.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.impl.CBuiltin;
import com.hp.hpl.jena.vocabulary.RDF;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

class CLit
extends CBuiltin {
    private static Set allSchemaTypes = new HashSet();
    static final Integer zero;
    static final Integer one;
    private static String rdfXMLLiteral;

    CLit(Node node, AbsChecker absChecker) {
        super(node, absChecker, CLit.literalCategory(node, absChecker));
    }

    static int literalCategory(Node node, AbsChecker absChecker) {
        LiteralLabel literalLabel = node.getLiteral();
        Object object = literalLabel.getValue();
        if (XSDDatatype.XSDnonNegativeInteger.isValidValue(object)) {
            if (!(object instanceof BigInteger) && !(object instanceof BigDecimal) && ((Number)object).longValue() >= 0L && ((Number)object).longValue() <= 1L) {
                return 15;
            }
            return 13;
        }
        String string = literalLabel.getDatatypeURI();
        if (string != null) {
            if (string.startsWith("http://www.w3.org/2001/XMLSchema#") && allSchemaTypes.contains(string.substring(33))) {
                return 16;
            }
            if (string.equals(rdfXMLLiteral)) {
                return 16;
            }
            absChecker.getCNode(Node.createURI((String)node.getLiteral().getDatatypeURI()));
            return 23;
        }
        return 16;
    }

    static {
        allSchemaTypes.add("float");
        allSchemaTypes.add("double");
        allSchemaTypes.add("int");
        allSchemaTypes.add("long");
        allSchemaTypes.add("short");
        allSchemaTypes.add("byte");
        allSchemaTypes.add("boolean");
        allSchemaTypes.add("string");
        allSchemaTypes.add("unsignedByte");
        allSchemaTypes.add("unsignedShort");
        allSchemaTypes.add("unsignedInt");
        allSchemaTypes.add("unsignedLong");
        allSchemaTypes.add("decimal");
        allSchemaTypes.add("integer");
        allSchemaTypes.add("nonPositiveInteger");
        allSchemaTypes.add("nonNegativeInteger");
        allSchemaTypes.add("positiveInteger");
        allSchemaTypes.add("negativeInteger");
        allSchemaTypes.add("normalizedString");
        allSchemaTypes.add("anyURI");
        allSchemaTypes.add("token");
        allSchemaTypes.add("Name");
        allSchemaTypes.add("QName");
        allSchemaTypes.add("language");
        allSchemaTypes.add("NMTOKEN");
        allSchemaTypes.add("ENTITIES");
        allSchemaTypes.add("NMTOKENS");
        allSchemaTypes.add("ENTITY");
        allSchemaTypes.add("ID");
        allSchemaTypes.add("NCName");
        allSchemaTypes.add("IDREF");
        allSchemaTypes.add("IDREFS");
        allSchemaTypes.add("NOTATION");
        allSchemaTypes.add("hexBinary");
        allSchemaTypes.add("base64Binary");
        allSchemaTypes.add("date");
        allSchemaTypes.add("time");
        allSchemaTypes.add("dateTime");
        allSchemaTypes.add("duration");
        allSchemaTypes.add("gDay");
        allSchemaTypes.add("gMonth");
        allSchemaTypes.add("gYear");
        allSchemaTypes.add("gYearMonth");
        allSchemaTypes.add("gMonthDay");
        zero = new Integer(0);
        one = new Integer(1);
        rdfXMLLiteral = RDF.getURI() + "XMLLiteral";
    }
}

