/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.ontology.tidy.impl.Constants;
import com.hp.hpl.jena.ontology.tidy.impl.Grammar;
import com.hp.hpl.jena.ontology.tidy.impl.Q;
import com.hp.hpl.jena.shared.BrokenException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class CategorySet
implements Comparable,
Serializable,
Constants {
    static final long serialVersionUID = -1280155302467590202L;
    private static final int[] cycles = new int[]{3, 4};
    private static final int[] untyped = new int[]{2, 5};
    private static final int[] orphanTypes = new int[]{75};
    private static final SortedSet sorted = new TreeSet();
    public static final Vector unsorted = new Vector();
    private int[] cats;
    private int id;
    static final int[] flags = new int[1000];
    static final int CYCLIC = 1;
    static final int UNTYPED = 2;
    static final int ORPHAN = 4;
    static final int DLORPHAN = 8;
    static final int STRUCT1 = 16;
    static final int STRUCT2 = 32;
    static boolean closed = false;

    private CategorySet(int[] nArray) {
        this.cats = nArray;
    }

    public int compareTo(Object object) {
        CategorySet categorySet = (CategorySet)object;
        int n = this.cats.length - categorySet.cats.length;
        for (int i = 0; n == 0 && i < this.cats.length; ++i) {
            n = this.cats[i] - categorySet.cats[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.cats.length; ++i) {
            n ^= this.cats[i] << i % 4;
        }
        return n;
    }

    public static synchronized int find(int[] nArray, boolean bl) {
        CategorySet categorySet;
        CategorySet categorySet2;
        SortedSet<CategorySet> sortedSet;
        if (nArray.length == 0) {
            return -1;
        }
        if (!bl) {
            Arrays.sort(nArray);
        }
        if (!(sortedSet = sorted.tailSet(categorySet2 = new CategorySet(nArray))).isEmpty() && (categorySet = sortedSet.first()).equals(categorySet2)) {
            return categorySet.id;
        }
        if (closed) {
            return -1;
        }
        categorySet2.id = unsorted.size();
        categorySet2.init();
        return categorySet2.id;
    }

    private void init() {
        int n = 0;
        unsorted.add(this);
        sorted.add(this);
        if (Q.intersect(cycles, this.cats)) {
            n |= 1;
        }
        if (Q.intersect(untyped, this.cats)) {
            n |= 2;
        }
        if (this.cats[0] == 1 && Q.intersect(orphanTypes, this.cats)) {
            n |= 4;
        }
        if (this.cats[0] == 1 && (Q.intersect(Grammar.restrictionsX, this.cats) || Q.intersect(Grammar.descriptionsX, this.cats))) {
            n |= 8;
        }
        if (Q.member(24, this.cats) || Q.member(44, this.cats) || Q.intersect(Grammar.descriptionsX, this.cats)) {
            n |= 0x10;
        }
        if (Q.intersect(Grammar.listsX, this.cats) || Q.intersect(Grammar.restrictionsX, this.cats)) {
            n |= 0x20;
        }
        CategorySet.flags[this.id] = n;
    }

    public static int[] getSet(int n) {
        return ((CategorySet)CategorySet.unsorted.elementAt((int)n)).cats;
    }

    public static String catString(int n) {
        int[] nArray = CategorySet.getSet(n);
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(Grammar.catNames[nArray[0]]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuffer.append(" ,");
            stringBuffer.append(Grammar.catNames[nArray[i]]);
        }
        return stringBuffer + " }";
    }

    public void restore() {
        if (this.id < unsorted.size()) {
            if (this.compareTo(unsorted.get(this.id)) != 0) {
                throw new BrokenException("Problems during restore of constants.");
            }
        } else if (this.id == unsorted.size()) {
            this.init();
        } else {
            throw new BrokenException("Problems during restore.");
        }
    }
}

