/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.TestCaseBasic;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCompatability
extends TestCase {
    public TestCompatability(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static TestSuite suite() {
        ConfigTestCaseRDB configTestCaseRDB = new ConfigTestCaseRDB(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, "Generic", TestPackage.M_DB);
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestCaseRDB("test0", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test1", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test2", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test3", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test4", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test5", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test6", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test7", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test8", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test9", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test10", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test11", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test12", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test13", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test14", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test15", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test16", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test17", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test18", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test19", configTestCaseRDB));
        return testSuite;
    }

    protected static class TestCaseRDB
    extends TestCaseBasic {
        ConfigTestCaseRDB m_config;

        public TestCaseRDB(String string, ConfigTestCaseRDB configTestCaseRDB) {
            super(string);
            this.m_config = configTestCaseRDB;
        }

        public void setUp() {
            this.m1 = this.m_config.createModel("jr1");
            this.m2 = this.m_config.createModel("jr2");
            this.m3 = this.m_config.createModel("jr3");
            this.m4 = this.m_config.createModel("jr4");
        }

        public void tearDown() {
            if (this.m_config.supportsMultipleModels && !this.m_config.noReformat) {
                this.cleanModel((ModelRDB)this.m1);
                this.m2.close();
                this.m3.close();
                this.m4.close();
                try {
                    this.m_config.m_dbconn.close();
                }
                catch (SQLException sQLException) {
                    System.out.println("Problem during db clean up in regression test");
                }
                this.m_config.m_dbconn = null;
            } else {
                this.cleanModel((ModelRDB)this.m1);
                this.cleanModel((ModelRDB)this.m2);
                this.cleanModel((ModelRDB)this.m3);
                this.cleanModel((ModelRDB)this.m4);
            }
        }

        private void cleanModel(ModelRDB modelRDB) {
            try {
                if (this.m_config.noReformat) {
                    StmtIterator stmtIterator = modelRDB.listStatements();
                    while (stmtIterator.hasNext()) {
                        stmtIterator.next();
                        stmtIterator.remove();
                    }
                } else {
                    modelRDB.getConnection().cleanDB();
                    modelRDB.close();
                }
            }
            catch (Exception exception) {
                TestCaseRDB.assertTrue((String)("Problem clearning up regression databases: " + exception), (boolean)false);
            }
        }
    }

    protected static class ConfigTestCaseRDB {
        String m_baseuri;
        String m_user;
        String m_password;
        String m_layout;
        String m_databaseType;
        boolean supportsMultipleModels;
        boolean supportsJenaReification;
        boolean noReformat;
        DBConnection m_dbconn = null;

        ConfigTestCaseRDB(String string, String string2, String string3, String string4, String string5) {
            this.m_baseuri = string;
            this.m_user = string2;
            this.m_password = string3;
            this.m_layout = string4;
            this.m_databaseType = string5;
            try {
                Class.forName(TestPackage.M_DBDRIVER_CLASS);
            }
            catch (Exception exception) {
                throw new JenaException("Unable to instantiate  driver: " + TestPackage.M_DBDRIVER_CLASS);
            }
            try {
                DBConnection dBConnection = new DBConnection(string, string2, string3);
                IRDBDriver iRDBDriver = dBConnection.getDriver(string4, string5);
                this.supportsMultipleModels = iRDBDriver.supportsMultipleModels();
                this.supportsJenaReification = iRDBDriver.supportsJenaReification();
            }
            catch (RDFRDBException rDFRDBException) {
                this.supportsMultipleModels = false;
            }
            this.noReformat = false;
        }

        ConfigTestCaseRDB(String string, String string2, String string3, String string4, String string5, boolean bl) {
            this(string, string2, string3, string4, string5);
            this.noReformat = bl;
        }

        ModelRDB createModel(String string) {
            if (this.supportsMultipleModels) {
                if (this.m_dbconn == null) {
                    this.m_dbconn = new DBConnection(this.m_baseuri, this.m_user, this.m_password, this.m_databaseType);
                    if (!this.m_dbconn.isFormatOK()) {
                        IRDBDriver iRDBDriver = this.m_dbconn.getDriver(this.m_layout, this.m_databaseType);
                        iRDBDriver.formatDB();
                    }
                }
                if (this.m_dbconn.containsModel(string)) {
                    ModelRDB.deleteModel(this.m_dbconn, string);
                }
                return ModelRDB.createModel((IDBConnection)this.m_dbconn, string);
            }
            DBConnection dBConnection = new DBConnection(this.m_baseuri + string, this.m_user, this.m_password);
            if (this.m_dbconn.containsDefaultModel()) {
                try {
                    this.m_dbconn.cleanDB();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ModelRDB.create(dBConnection, this.m_layout, this.m_databaseType);
        }
    }
}

