/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;

public class Personality {
    private Map types = CollectionFactory.createHashedMap();

    protected Personality() {
    }

    public Personality(Personality personality) {
        this();
        this.add(personality);
    }

    public Personality add(Class clazz, Implementation implementation) {
        this.types.put(clazz, implementation);
        return this;
    }

    public Personality copy() {
        return new Personality(this);
    }

    Implementation getImplementation(Class clazz) {
        return (Implementation)this.types.get(clazz);
    }

    Personality add(Personality personality) {
        this.types.putAll(personality.types);
        return this;
    }

    public Polymorphic newInstance(Class clazz, Node node, Polymorphic polymorphic) {
        Implementation implementation = (Implementation)this.types.get(clazz);
        if (implementation == null) {
            throw new PersonalityConfigException(clazz + " not in Personality.");
        }
        EnhNode enhNode = implementation.wrap(node, (EnhGraph)polymorphic);
        if (!clazz.isInstance(enhNode)) {
            throw new PersonalityConfigException(clazz + " misconfigured.");
        }
        return enhNode;
    }

    protected Map getMap() {
        return this.types;
    }
}

