/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.shared.JenaException;
import java.io.File;

public class FileGraphTransactionHandler
extends TransactionHandlerBase
implements TransactionHandler {
    protected boolean inTransaction;
    protected FileGraph fileGraph;
    protected File checkPointFile;

    public FileGraphTransactionHandler(FileGraph fileGraph) {
        this.fileGraph = fileGraph;
    }

    public boolean transactionsSupported() {
        return true;
    }

    public void begin() {
        if (this.inTransaction) {
            throw new JenaException("nested transactions not supported");
        }
        this.checkPointFile = new File(this.checkPointName(this.fileGraph.name));
        this.checkPointFile.deleteOnExit();
        this.fileGraph.saveContents(this.checkPointFile);
        this.inTransaction = true;
    }

    protected String checkPointName(File file) {
        String string = file.getPath();
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        return string2 + "checkPoint-" + string3;
    }

    public void abort() {
        this.fileGraph.getBulkUpdateHandler().removeAll();
        this.fileGraph.readModelFrom(this.fileGraph.model, true, this.checkPointFile);
        this.checkPointFile.delete();
        this.inTransaction = false;
    }

    public void commit() {
        this.fileGraph.saveContents(this.fileGraph.name);
        this.checkPointFile.delete();
        this.inTransaction = false;
    }
}

