/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.FragmentTripleIterator;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentHandler;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleReifierFragmentsMap
implements ReifierFragmentsMap {
    protected Map forwardMap = CollectionFactory.createHashedMap();
    protected static final int TYPES_index = 0;
    protected static final int SUBJECTS_index = 1;
    protected static final int PREDICATES_index = 2;
    protected static final int OBJECTS_index = 3;
    protected final ReifierFragmentHandler TYPES = new SimpleReifierFragmentHandler(this, 0){

        public boolean clashesWith(ReifierFragmentsMap reifierFragmentsMap, Node node, Triple triple) {
            return false;
        }
    };
    protected final ReifierFragmentHandler SUBJECTS = new SimpleReifierFragmentHandler(this, 1){

        public boolean clashesWith(ReifierFragmentsMap reifierFragmentsMap, Node node, Triple triple) {
            return !node.equals(triple.getSubject());
        }
    };
    protected final ReifierFragmentHandler PREDICATES = new SimpleReifierFragmentHandler(this, 2){

        public boolean clashesWith(ReifierFragmentsMap reifierFragmentsMap, Node node, Triple triple) {
            return !node.equals(triple.getPredicate());
        }
    };
    protected final ReifierFragmentHandler OBJECTS = new SimpleReifierFragmentHandler(this, 3){

        public boolean clashesWith(ReifierFragmentsMap reifierFragmentsMap, Node node, Triple triple) {
            return !node.equals(triple.getObject());
        }
    };
    public final Map selectors = this.makeSelectors();

    protected Fragments getFragments(Node node) {
        return (Fragments)this.forwardMap.get(node);
    }

    protected void removeFragments(Node node) {
        this.forwardMap.remove(node);
    }

    protected Fragments putFragments(Node node, Fragments fragments) {
        this.forwardMap.put(node, fragments);
        return fragments;
    }

    protected ExtendedIterator allTriples(TripleMatch tripleMatch) {
        Triple triple = tripleMatch.asTriple();
        Node node = triple.getSubject();
        if (node.isConcrete()) {
            Fragments fragments = (Fragments)this.forwardMap.get(node);
            return fragments == null ? NullIterator.instance : this.explodeFragments(triple, node, fragments);
        }
        Iterator iterator = this.forwardMap.entrySet().iterator();
        return new FragmentTripleIterator(triple, iterator){

            public void fill(GraphAdd graphAdd, Node node, Object object) {
                ((Fragments)object).includeInto(graphAdd);
            }
        };
    }

    protected ExtendedIterator explodeFragments(Triple triple, Node node, Fragments fragments) {
        GraphAddList graphAddList = new GraphAddList(triple);
        fragments.includeInto(graphAddList);
        return WrappedIterator.create(graphAddList.iterator());
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.allTriples(tripleMatch);
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.forwardMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Fragments fragments = (Fragments)entry.getValue();
            n += fragments.size();
        }
        return n;
    }

    public ReifierFragmentHandler getFragmentHandler(Triple triple) {
        Node node = triple.getPredicate();
        ReifierFragmentHandler reifierFragmentHandler = (ReifierFragmentHandler)this.selectors.get(node);
        if (reifierFragmentHandler == null || node.equals(RDF.Nodes.type) && !triple.getObject().equals(RDF.Nodes.Statement)) {
            return null;
        }
        return reifierFragmentHandler;
    }

    protected void putAugmentedTriple(SimpleReifierFragmentHandler simpleReifierFragmentHandler, Node node, Node node2, Triple triple) {
        Fragments fragments = new Fragments(node, triple);
        fragments.add(simpleReifierFragmentHandler, node2);
        this.putFragments(node, fragments);
    }

    protected Triple reifyCompleteQuad(SimpleReifierFragmentHandler simpleReifierFragmentHandler, Triple triple, Node node, Node node2) {
        Fragments fragments = this.getFragments(node);
        if (fragments == null) {
            fragments = new Fragments(node);
            this.putFragments(node, fragments);
        }
        fragments.add(simpleReifierFragmentHandler, node2);
        if (fragments.isComplete()) {
            this.removeFragments(triple.getSubject());
            return fragments.asTriple();
        }
        return null;
    }

    protected Triple removeFragment(SimpleReifierFragmentHandler simpleReifierFragmentHandler, Node node, Triple triple, Triple triple2) {
        Fragments fragments = this.getFragments(node);
        Fragments fragments2 = triple != null ? this.explode(node, triple) : (fragments == null ? this.putFragments(node, new Fragments(node)) : fragments);
        fragments2.remove(simpleReifierFragmentHandler, triple2.getObject());
        if (fragments2.isComplete()) {
            Triple triple3 = fragments2.asTriple();
            this.removeFragments(node);
            return triple3;
        }
        if (fragments2.isEmpty()) {
            this.removeFragments(node);
        }
        return null;
    }

    protected Fragments explode(Node node, Triple triple) {
        return this.putFragments(node, new Fragments(node, triple));
    }

    public boolean hasFragments(Node node) {
        return this.getFragments(node) != null;
    }

    protected Map makeSelectors() {
        Map map = CollectionFactory.createHashedMap();
        map.put(RDF.Nodes.subject, this.SUBJECTS);
        map.put(RDF.Nodes.predicate, this.PREDICATES);
        map.put(RDF.Nodes.object, this.OBJECTS);
        map.put(RDF.Nodes.type, this.TYPES);
        return map;
    }

    protected static class Fragments {
        private final Set[] slots = new Set[]{CollectionFactory.createHashedSet(), CollectionFactory.createHashedSet(), CollectionFactory.createHashedSet(), CollectionFactory.createHashedSet()};
        private Node anchor;

        public Fragments(Node node) {
            this.anchor = node;
        }

        public Fragments(Node node, Triple triple) {
            this(node);
            this.addTriple(triple);
        }

        public int size() {
            return this.slots[0].size() + this.slots[1].size() + this.slots[2].size() + this.slots[3].size();
        }

        public boolean isComplete() {
            return this.slots[0].size() == 1 && this.slots[1].size() == 1 && this.slots[2].size() == 1 && this.slots[3].size() == 1;
        }

        public boolean isEmpty() {
            return this.slots[0].isEmpty() && this.slots[1].isEmpty() && this.slots[2].isEmpty() && this.slots[3].isEmpty();
        }

        public void remove(SimpleReifierFragmentHandler simpleReifierFragmentHandler, Node node) {
            this.slots[simpleReifierFragmentHandler.which].remove(node);
        }

        public void add(SimpleReifierFragmentHandler simpleReifierFragmentHandler, Node node) {
            this.slots[simpleReifierFragmentHandler.which].add(node);
        }

        public void includeInto(GraphAdd graphAdd) {
            this.includeInto(graphAdd, RDF.Nodes.subject, 1);
            this.includeInto(graphAdd, RDF.Nodes.predicate, 2);
            this.includeInto(graphAdd, RDF.Nodes.object, 3);
            this.includeInto(graphAdd, RDF.Nodes.type, 0);
        }

        private void includeInto(GraphAdd graphAdd, Node node, int n) {
            Iterator iterator = this.slots[n].iterator();
            while (iterator.hasNext()) {
                graphAdd.add(Triple.create(this.anchor, node, (Node)iterator.next()));
            }
        }

        public Fragments addTriple(Triple triple) {
            this.slots[1].add(triple.getSubject());
            this.slots[2].add(triple.getPredicate());
            this.slots[3].add(triple.getObject());
            this.slots[0].add(RDF.Nodes.Statement);
            return this;
        }

        Triple asTriple() {
            return Triple.create(this.only(this.slots[1]), this.only(this.slots[2]), this.only(this.slots[3]));
        }

        private Node only(Set set) {
            return (Node)set.iterator().next();
        }

        public String toString() {
            return this.anchor + " s:" + this.slots[1] + " p:" + this.slots[2] + " o:" + this.slots[3] + " t:" + this.slots[0];
        }
    }
}

