/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.query.FixedValuator;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.VariableValues;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Set;

public interface Expression {
    public static final Expression TRUE = new BoolConstant(true);
    public static final Expression FALSE = new BoolConstant(false);

    public Valuator prepare(VariableIndexes var1);

    public boolean isVariable();

    public String getName();

    public boolean isConstant();

    public Object getValue();

    public boolean isApply();

    public String getFun();

    public int argCount();

    public Expression getArg(int var1);

    public static class BoolConstant
    extends Base
    implements Expression,
    Valuator {
        private boolean value;

        public BoolConstant(boolean bl) {
            this.value = bl;
        }

        public boolean isConstant() {
            return true;
        }

        public Object getValue() {
            return this.value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Valuator prepare(VariableIndexes variableIndexes) {
            return this;
        }

        public boolean evalBool(VariableValues variableValues) {
            return this.value;
        }

        public boolean evalBool(IndexValues indexValues) {
            return this.value;
        }

        public Object evalObject(IndexValues indexValues) {
            return this.getValue();
        }
    }

    public static class Valof
    implements VariableValues {
        private VariableIndexes map;
        private IndexValues dom;

        public Valof(VariableIndexes variableIndexes) {
            this.map = variableIndexes;
        }

        public final Object get(String string) {
            return this.dom.get(this.map.indexOf(string));
        }

        public final Valof setDomain(IndexValues indexValues) {
            this.dom = indexValues;
            return this;
        }
    }

    public static class Util {
        public static Set variablesOf(Expression expression) {
            return Util.addVariablesOf(CollectionFactory.createHashedSet(), expression);
        }

        public static Set addVariablesOf(Set set, Expression expression) {
            if (expression.isVariable()) {
                set.add(expression.getName());
            } else if (expression.isApply()) {
                for (int i = 0; i < expression.argCount(); ++i) {
                    Util.addVariablesOf(set, expression.getArg(i));
                }
            }
            return set;
        }

        public static boolean containsAllVariablesOf(Set set, Expression expression) {
            if (expression.isConstant()) {
                return true;
            }
            if (expression.isVariable()) {
                return set.contains(expression.getName());
            }
            if (expression.isApply()) {
                for (int i = 0; i < expression.argCount(); ++i) {
                    if (Util.containsAllVariablesOf(set, expression.getArg(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static boolean equals(Expression expression, Expression expression2) {
            return expression.isConstant() ? expression2.isConstant() && expression.getValue().equals(expression2.getValue()) : (expression.isVariable() ? expression2.isVariable() && expression2.getName().equals(expression2.getName()) : (expression.isApply() ? expression2.isApply() && Util.sameApply(expression, expression2) : false));
        }

        public static boolean sameApply(Expression expression, Expression expression2) {
            return expression.argCount() == expression2.argCount() && expression.getFun().equals(expression2.getFun()) && Util.sameArgs(expression, expression2);
        }

        public static boolean sameArgs(Expression expression, Expression expression2) {
            for (int i = 0; i < expression.argCount(); ++i) {
                if (Util.equals(expression.getArg(i), expression2.getArg(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class Application
    extends Base {
        public boolean isApply() {
            return true;
        }

        public abstract int argCount();

        public abstract String getFun();

        public abstract Expression getArg(int var1);
    }

    public static abstract class Variable
    extends Base {
        public boolean isVariable() {
            return true;
        }

        public abstract String getName();
    }

    public static class Fixed
    extends Constant {
        protected Object value;

        public Fixed(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public Valuator prepare(VariableIndexes variableIndexes) {
            return new FixedValuator(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static abstract class Constant
    extends Base {
        public boolean isConstant() {
            return true;
        }

        public abstract Object getValue();
    }

    public static abstract class Base
    implements Expression {
        public boolean isVariable() {
            return false;
        }

        public boolean isApply() {
            return false;
        }

        public boolean isConstant() {
            return false;
        }

        public String getName() {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public int argCount() {
            return 0;
        }

        public String getFun() {
            return null;
        }

        public Expression getArg(int n) {
            return null;
        }

        public boolean equals(Object object) {
            return object instanceof Expression && Util.equals(this, (Expression)object);
        }
    }
}

