/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.SlotValuator;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.List;

public abstract class QueryTestBase
extends GraphTestBase {
    protected static Map1 getFirst = new Map1(){

        public Object map1(Object object) {
            return ((List)object).get(0);
        }
    };
    protected static final IndexValues noIVs = new IndexValues(){

        public Object get(int n) {
            return null;
        }
    };
    protected static final Mapping emptyMapping = new Mapping(new Node[0]);
    protected VariableIndexes noVariables = new VariableIndexes(){

        public int indexOf(String string) {
            return -1;
        }
    };
    protected static final Node X = Query.X;
    protected static final Node Y = Query.Y;
    protected static final Node Z = Query.Z;
    protected static final Node ANY = Node.ANY;
    protected final Node[] justX = new Node[]{X};

    public QueryTestBase(String string) {
        super(string);
    }

    protected Expression notEqual(Node node, Node node2) {
        return new Dyadic(QueryTestBase.asExpression(node), "http://jena.hpl.hp.com/constraints/NE", QueryTestBase.asExpression(node2)){

            public boolean evalBool(Object object, Object object2) {
                return !object.equals(object2);
            }
        };
    }

    protected Expression areEqual(Node node, Node node2) {
        return new Dyadic(QueryTestBase.asExpression(node), "http://jena.hpl.hp.com/constraints/EQ", QueryTestBase.asExpression(node2)){

            public boolean evalBool(Object object, Object object2) {
                return object.equals(object2);
            }
        };
    }

    protected Expression matches(Node node, Node node2) {
        return new Dyadic(QueryTestBase.asExpression(node), "http://jena.hpl.hp.com/constraints/MATCHES", QueryTestBase.asExpression(node2)){

            public boolean evalBool(Object object, Object object2) {
                Node node = (Node)object;
                Node node2 = (Node)object2;
                return node.toString(false).indexOf(node2.toString(false)) > -1;
            }
        };
    }

    public static Expression asExpression(final Node node) {
        if (node.isVariable()) {
            return new Expression.Variable(){

                public String getName() {
                    return node.getName();
                }

                public Valuator prepare(VariableIndexes variableIndexes) {
                    return new SlotValuator(variableIndexes.indexOf(node.getName()));
                }
            };
        }
        return new Expression.Fixed(node);
    }
}

