/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class N3JenaWriterTests
extends N3ExternalTestsCom {
    static final String uriBase = "http://host/base/";

    public static TestSuite suite() {
        return new N3JenaWriterTests();
    }

    public N3JenaWriterTests() {
        this("n3-writer-tests");
    }

    public N3JenaWriterTests(String string) {
        super("N3 Jena Writer tests", string);
    }

    protected void makeTest(String string, String string2) {
        String string3 = string;
        if (this.basedir != null) {
            string = this.basedir + "/" + string;
        }
        if (this.basedir != null && string2 != null && !string2.equals("")) {
            string2 = this.basedir + "/" + string2;
        }
        this.addTest((junit.framework.Test)new Test(string3, string, string2, "N3-PP"));
        this.addTest((junit.framework.Test)new Test(string3, string, string2, "N3-PLAIN"));
        this.addTest((junit.framework.Test)new Test(string3, string, string2, "N3-TRIPLES"));
    }

    static class Test
    extends TestCase {
        String writerName = null;
        String testName = null;
        String basename = null;
        String inputFile = null;
        String resultsFile = null;
        Reader data = null;

        Test(String string, String string2, String string3, String string4) {
            super("N3 Jena Writer test: " + string + "-" + string4);
            this.testName = string;
            this.inputFile = string2;
            this.resultsFile = string3;
            this.writerName = string4;
        }

        protected void runTest() throws Throwable {
            try {
                this.data = N3ExternalTestsCom.makeReader(new FileInputStream(this.inputFile));
            }
            catch (IOException iOException) {
                Test.fail((String)("File does not exist: " + this.inputFile));
                return;
            }
            Model model = ModelFactory.createDefaultModel();
            model.read(this.data, N3JenaWriterTests.uriBase, "N3");
            StringWriter stringWriter = new StringWriter();
            model.write(stringWriter, this.writerName, N3JenaWriterTests.uriBase);
            stringWriter.close();
            StringReader stringReader = new StringReader(stringWriter.toString());
            Model model2 = ModelFactory.createDefaultModel();
            model2.read(stringReader, N3JenaWriterTests.uriBase, "N3");
            if (!model.isIsomorphicWith(model2)) {
                System.out.println("#### ---- " + this.testName + " ------------------------------");
                System.out.println("#### Model 1 ---- " + this.testName + " ------------------------------");
                model.write(System.out, "N3");
                System.out.println("#### Model 2 --- " + this.testName + " ------------------------------");
                model2.write(System.out, "N3");
                Test.assertTrue((String)("Models don't match: " + this.testName), (boolean)false);
            }
        }
    }
}

