/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.RDFListImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;

public class DAMLListImpl
extends RDFListImpl
implements DAMLList {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLListImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLList");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Graph graph = enhGraph.asGraph();
            return node.equals(DAML_OIL.nil.asNode()) || graph.find(node, DAML_OIL.first.asNode(), Node.ANY).hasNext() || graph.find(node, DAML_OIL.rest.asNode(), Node.ANY).hasNext() || graph.find(node, RDF.type.asNode(), DAML_OIL.List.asNode()).hasNext();
        }
    };

    public DAMLListImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public Resource listType() {
        return DAML_OIL.List;
    }

    public Resource listNil() {
        return DAML_OIL.nil;
    }

    public Property listFirst() {
        return DAML_OIL.first;
    }

    public Property listRest() {
        return DAML_OIL.rest;
    }

    public Class listAbstractionClass() {
        return DAMLList.class;
    }

    public ExtendedIterator getAll() {
        return this.iterator();
    }

    public RDFNode getFirst() {
        return this.getHead();
    }

    public DAMLList getRest() {
        return (DAMLList)this.getTail().as(DAMLList.class);
    }

    public int getCount() {
        return this.size();
    }

    public void setFirst(DAMLCommon dAMLCommon) {
        this.setHead(dAMLCommon);
    }

    public void setRest(DAMLList dAMLList) {
        this.setTail(dAMLList);
    }

    public void setRestNil() {
        this.setRest(this.getNil());
    }

    public DAMLList cons(DAMLCommon dAMLCommon) {
        return (DAMLList)super.cons(dAMLCommon).as(DAMLList.class);
    }

    public DAMLList getNil() {
        return (DAMLList)this.listNil().as(DAMLList.class);
    }

    public boolean isNil(Resource resource) {
        return ((Object)resource).equals(this.listNil());
    }

    public DAMLList findLast() {
        return (DAMLList)this.findElement(true, 0).as(DAMLList.class);
    }

    public DAMLCommon getItem(int n) {
        return (DAMLCommon)this.get(n).as(DAMLCommon.class);
    }
}

