/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OWLDLProfile
extends OWLProfile {
    protected static Object[][] s_supportsCheckData = new Object[][]{{AllDifferent.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {AnnotationProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            Iterator iterator = ((OntModel)((Object)enhGraph)).getProfile().getAnnotationProperties();
            while (iterator.hasNext()) {
                if (!((Resource)iterator.next()).asNode().equals(node)) continue;
                return true;
            }
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {OntClass.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return OWL.Thing.asNode().equals(node) || OWL.Nothing.asNode().equals(node) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Class.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), RDFS.Class.asNode()) || node.equals(OWL.Thing.asNode()) || node.equals(OWL.Nothing.asNode()) || enhGraph.asGraph().contains(Node.ANY, RDFS.domain.asNode(), node) || enhGraph.asGraph().contains(Node.ANY, RDFS.range.asNode(), node);
        }
    }}, {DatatypeProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {ObjectProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode());
        }
    }}, {FunctionalProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {InverseFunctionalProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {RDFList.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return node.equals(RDF.nil.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), RDF.Property.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.FunctionalProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode());
        }
    }}, {Ontology.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {Restriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {AllValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(enhGraph, node, OWL.allValuesFrom) && OWLDLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {SomeValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(enhGraph, node, OWL.someValuesFrom) && OWLDLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {HasValueRestriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(enhGraph, node, OWL.hasValue) && OWLDLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {CardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(enhGraph, node, OWL.cardinality) && OWLDLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {MinCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(enhGraph, node, OWL.minCardinality) && OWLDLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {MaxCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(enhGraph, node, OWL.maxCardinality) && OWLDLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {SymmetricProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {TransitiveProperty.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {Individual.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            if (node instanceof Node_URI || node instanceof Node_Blank) {
                Graph graph = enhGraph.asGraph();
                return !graph.contains(node, RDF.type.asNode(), RDFS.Class.asNode()) && !graph.contains(node, RDF.type.asNode(), RDF.Property.asNode());
            }
            return false;
        }
    }}, {DataRange.class, new OWLProfile.SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return node instanceof Node_Blank && enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DataRange.asNode());
        }
    }}};
    private static HashMap s_supportsChecks = new HashMap();

    public String getLabel() {
        return "OWL DL";
    }

    public static boolean containsSome(EnhGraph enhGraph, Node node, Property property) {
        return AbstractProfile.containsSome(enhGraph, node, property);
    }

    protected Map getCheckTable() {
        return s_supportsChecks;
    }

    static {
        for (int i = 0; i < s_supportsCheckData.length; ++i) {
            s_supportsChecks.put(s_supportsCheckData[i][0], s_supportsCheckData[i][1]);
        }
    }
}

