/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPOptions;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaHandler;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.SingleThreadedParser;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.UnknownPropertyException;
import com.hp.hpl.jena.shared.WrappedIOException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JenaReader
implements RDFReader,
ARPErrorNumbers {
    private static final int BULK_UPDATE_SIZE = 1000;
    private static final String saxFeaturesURL = "http://xml.org/sax/features/";
    private static final String saxPropertiesURL = "http://xml.org/sax/properties/";
    private static final String apacheFeaturesURL = "http://apache.org/xml/features/";
    private static final String apachePropertiesURL = "http://apache.org/xml/properties/";
    static final String arpPropertiesURL = "http://jena.hpl.hp.com/arp/properties/";
    static final int arpPropertiesURLLength = "http://jena.hpl.hp.com/arp/properties/".length();
    private final SingleThreadedParser arpf;
    private Model model;
    private JenaHandler handler;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public static void useMe(Model model) {
        model.setReaderClassName("RDF/XML", JenaReader.class.getName());
        model.setReaderClassName("RDF/XML-ABBREV", JenaReader.class.getName());
    }

    public JenaReader() {
        this.arpf = SingleThreadedParser.create();
    }

    public void read(Model model, String string) throws JenaException {
        try {
            URLConnection uRLConnection = new URL(string).openConnection();
            String string2 = uRLConnection.getContentEncoding();
            if (string2 == null) {
                this.read(model, uRLConnection.getInputStream(), string);
            } else {
                this.read(model, (Reader)new InputStreamReader(uRLConnection.getInputStream(), string2), string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DoesNotExistException(string);
        }
        catch (IOException iOException) {
            throw new JenaException(iOException);
        }
    }

    public static Literal translate(ALiteral aLiteral) {
        return new LiteralImpl(((Object)aLiteral).toString(), aLiteral.getLang(), aLiteral.isWellFormedXML(), null);
    }

    static Node convert(ALiteral aLiteral) {
        String string = aLiteral.getDatatypeURI();
        if (string == null) {
            return Node.createLiteral(((Object)aLiteral).toString(), aLiteral.getLang(), false);
        }
        if (aLiteral.isWellFormedXML()) {
            return Node.createLiteral(((Object)aLiteral).toString(), null, true);
        }
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string);
        return Node.createLiteral(((Object)aLiteral).toString(), null, rDFDatatype);
    }

    static Node convert(AResource aResource) {
        if (aResource.isAnonymous()) {
            String string = aResource.getAnonymousID();
            Node node = (Node)aResource.getUserData();
            if (node == null) {
                node = Node.createAnon();
                aResource.setUserData(node);
            }
            return node;
        }
        return Node.createURI(aResource.getURI());
    }

    static Triple convert(AResource aResource, AResource aResource2, AResource aResource3) {
        return Triple.create(JenaReader.convert(aResource), JenaReader.convert(aResource2), JenaReader.convert(aResource3));
    }

    static Triple convert(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        return Triple.create(JenaReader.convert(aResource), JenaReader.convert(aResource2), JenaReader.convert(aLiteral));
    }

    public static Property translatePred(AResource aResource) throws JenaException {
        return new PropertyImpl(aResource.getURI());
    }

    private void read(Model model, InputSource inputSource, String string) throws JenaException {
        this.model = model;
        if (string != null && !string.equals("")) {
            try {
                URI uRI = new URI(string);
            }
            catch (MalformedURIException malformedURIException) {
                this.errorHandler.error(malformedURIException);
            }
        }
        this.read(this.model.getGraph(), inputSource, string, this.model);
    }

    private synchronized void read(Graph graph, InputSource inputSource, String string, Model model) {
        try {
            try {
                graph.getEventManager().notifyEvent(graph, GraphEvents.startRead);
                inputSource.setSystemId(string);
                this.handler = new JenaHandler(graph, model, this.errorHandler);
                this.handler.useWith(this.arpf.getHandlers());
                this.arpf.parse(inputSource, string);
                this.handler.bulkUpdate();
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
            catch (SAXException sAXException) {
                throw new JenaException(sAXException);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            graph.getEventManager().notifyEvent(graph, GraphEvents.finishRead);
            this.handler = null;
            throw throwable;
        }
        graph.getEventManager().notifyEvent(graph, GraphEvents.finishRead);
        this.handler = null;
    }

    public void read(Model model, Reader reader, String string) throws JenaException {
        this.read(model, new InputSource(reader), string);
    }

    public void read(Graph graph, Reader reader, String string) throws JenaException {
        this.read(graph, new InputSource(reader), string, null);
    }

    public void read(Model model, InputStream inputStream, String string) throws JenaException {
        this.read(model, new InputSource(inputStream), string);
    }

    public void read(Graph graph, InputStream inputStream, String string) {
        this.read(graph, new InputSource(inputStream), string, null);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        JenaHandler jenaHandler = this.handler;
        if (jenaHandler != null) {
            jenaHandler.setErrorHandler(rDFErrorHandler);
        }
        return rDFErrorHandler2;
    }

    public Object setProperty(String string, Object object) throws JenaException {
        Object object2 = object;
        if (string.startsWith("http:")) {
            if (string.startsWith(arpPropertiesURL)) {
                return this.setArpProperty(string.substring(arpPropertiesURLLength), object2);
            }
            if (string.startsWith(saxPropertiesURL) || string.startsWith(apachePropertiesURL)) {
                Object object3;
                try {
                    object3 = this.arpf.getSAXParser().getProperty(string);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    object3 = null;
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new UnknownPropertyException(string));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setProperty(string, object2);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.errorHandler.error(new JenaException(sAXNotSupportedException));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new UnknownPropertyException(string));
                    return null;
                }
                return object3;
            }
            if (string.startsWith(saxFeaturesURL) || string.startsWith(apacheFeaturesURL)) {
                Boolean bl;
                try {
                    bl = new Boolean(this.arpf.getSAXParser().getFeature(string));
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    bl = null;
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new UnknownPropertyException(string));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setFeature(string, ((Boolean)object2).booleanValue());
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.errorHandler.error(new JenaException(sAXNotSupportedException));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new UnknownPropertyException(string));
                    return null;
                }
                catch (ClassCastException classCastException) {
                    this.errorHandler.error(new JenaException(new SAXNotSupportedException("Feature: '" + string + "' can only have a boolean value.")));
                }
                return bl;
            }
        }
        return this.setArpProperty(string, object2);
    }

    public static int errorCode(String string) {
        Class clazz = ARPErrorNumbers.class;
        try {
            Field field = clazz.getField(string);
            return field.getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String errorCodeName(int n) {
        Class clazz = ARPErrorNumbers.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                if (fieldArray[i].getInt(null) != n) continue;
                return fieldArray[i].getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object setArpProperty(String string, Object object) {
        return JenaReader.setArpProperty(this.arpf.getOptions(), string, object, this.errorHandler);
    }

    static Object setArpProperty(ARPOptions aRPOptions, String string, Object object, RDFErrorHandler rDFErrorHandler) {
        int n;
        string = string.toUpperCase();
        if (object == null) {
            object = "";
        }
        if (object instanceof String) {
            object = ((String)object).toUpperCase();
        }
        if (string.equals("ERROR-MODE")) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.equals("LAX")) {
                    aRPOptions.setLaxErrorMode();
                    return null;
                }
                if (string2.equals("DEFAULT")) {
                    aRPOptions.setDefaultErrorMode();
                    return null;
                }
                if (string2.equals("STRICT")) {
                    aRPOptions.setStrictErrorMode();
                    return null;
                }
                if (string2.equals("STRICT-WARNING")) {
                    aRPOptions.setStrictErrorMode(1);
                    return null;
                }
                if (string2.equals("STRICT-FATAL")) {
                    aRPOptions.setStrictErrorMode(3);
                    return null;
                }
                if (string2.equals("STRICT-IGNORE")) {
                    aRPOptions.setStrictErrorMode(0);
                    return null;
                }
                if (string2.equals("STRICT-ERROR")) {
                    aRPOptions.setStrictErrorMode(2);
                    return null;
                }
            }
            rDFErrorHandler.error(new IllegalArgumentException("Property \"ERROR-MODE\" takes the following values: \"default\", \"lax\", \"strict\", \"strict-ignore\", \"strict-warning\", \"strict-error\", \"strict-fatal\"."));
            return null;
        }
        if (string.equals("EMBEDDING")) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            if (!(object instanceof Boolean)) {
                rDFErrorHandler.error(new IllegalArgumentException("Property \"EMBEDDING\" requires a boolean value."));
                boolean bl = aRPOptions.setEmbedding(false);
                aRPOptions.setEmbedding(bl);
                return new Boolean(bl);
            }
            return new Boolean(aRPOptions.setEmbedding((Boolean)object));
        }
        if ((string.startsWith("ERR_") || string.startsWith("IGN_") || string.startsWith("WARN_")) && (n = JenaReader.errorCode(string)) != -1) {
            int n2;
            if (object instanceof String) {
                if (((String)object).startsWith("EM_") && (n2 = JenaReader.errorCode((String)object)) != -1) {
                    int n4 = aRPOptions.setErrorMode(n, n2);
                    return new Integer(n4);
                }
            } else if (object instanceof Integer) {
                n2 = (Integer)object;
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int n5 = aRPOptions.setErrorMode(n, n2);
                        return new Integer(n5);
                    }
                }
            }
            rDFErrorHandler.error(new IllegalArgumentException("Property \"" + string + "\" cannot have value: " + object.toString()));
            n2 = aRPOptions.setErrorMode(n, 2);
            aRPOptions.setErrorMode(n, n2);
            return new Integer(n2);
        }
        rDFErrorHandler.error(new UnknownPropertyException(string));
        return null;
    }

    public static Model memModel() {
        Model model = ModelFactory.createDefaultModel();
        JenaReader.useMe(model);
        return model;
    }
}

