/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AltHasNoDefaultException;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.vocabulary.RDF;

public class AltImpl
extends ContainerImpl
implements Alt {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return true;
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new AltImpl(node, enhGraph);
        }
    };

    public AltImpl(ModelCom modelCom) {
        super(modelCom);
    }

    public AltImpl(String string, ModelCom modelCom) {
        super(string, modelCom);
    }

    public AltImpl(Resource resource, ModelCom modelCom) {
        super(resource, modelCom);
    }

    public AltImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    private Statement needDefaultStatement() {
        Statement statement = this.getDefaultStatement();
        if (statement == null) {
            throw new AltHasNoDefaultException(this);
        }
        return statement;
    }

    public RDFNode getDefault() {
        return this.needDefaultStatement().getObject();
    }

    public Resource getDefaultResource() {
        return this.needDefaultStatement().getResource();
    }

    public Literal getDefaultLiteral() {
        return this.needDefaultStatement().getLiteral();
    }

    public boolean getDefaultBoolean() {
        return this.needDefaultStatement().getBoolean();
    }

    public byte getDefaultByte() {
        return this.needDefaultStatement().getByte();
    }

    public short getDefaultShort() {
        return this.needDefaultStatement().getShort();
    }

    public int getDefaultInt() {
        return this.needDefaultStatement().getInt();
    }

    public long getDefaultLong() {
        return this.needDefaultStatement().getLong();
    }

    public char getDefaultChar() {
        return this.needDefaultStatement().getChar();
    }

    public float getDefaultFloat() {
        return this.needDefaultStatement().getFloat();
    }

    public double getDefaultDouble() {
        return this.needDefaultStatement().getDouble();
    }

    public String getDefaultString() {
        return this.needDefaultStatement().getString();
    }

    public String getDefaultLanguage() {
        return this.needDefaultStatement().getLanguage();
    }

    public Resource getDefaultResource(ResourceF resourceF) {
        return this.needDefaultStatement().getResource();
    }

    public Object getDefaultObject(ObjectF objectF) {
        return this.needDefaultStatement().getObject(objectF);
    }

    public Alt getDefaultAlt() {
        return this.needDefaultStatement().getAlt();
    }

    public Bag getDefaultBag() {
        return this.needDefaultStatement().getBag();
    }

    public Seq getDefaultSeq() {
        return this.needDefaultStatement().getSeq();
    }

    public Alt setDefault(RDFNode rDFNode) {
        Statement statement = this.getDefaultStatement();
        if (statement != null) {
            this.getModel().remove(statement);
        }
        this.getModel().add((Resource)this, RDF.li(1), rDFNode);
        return this;
    }

    public Alt setDefault(boolean bl) {
        return this.setDefault(String.valueOf(bl));
    }

    public Alt setDefault(long l) {
        return this.setDefault(String.valueOf(l));
    }

    public Alt setDefault(char c) {
        return this.setDefault(String.valueOf(c));
    }

    public Alt setDefault(float f) {
        return this.setDefault(String.valueOf(f));
    }

    public Alt setDefault(double d) {
        return this.setDefault(String.valueOf(d));
    }

    public Alt setDefault(Object object) {
        return this.setDefault(String.valueOf(object));
    }

    public Alt setDefault(String string) {
        return this.setDefault(string, "");
    }

    public Alt setDefault(String string, String string2) {
        return this.setDefault(new LiteralImpl(Node.createLiteral(string, string2, false), this.getModelCom()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement getDefaultStatement() {
        StmtIterator stmtIterator = this.getModel().listStatements((Resource)this, RDF.li(1), (RDFNode)null);
        try {
            Statement statement = stmtIterator.hasNext() ? stmtIterator.nextStatement() : null;
            return statement;
        }
        finally {
            stmtIterator.close();
        }
    }
}

