/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class ModelSpecFactory {
    protected static ModelSpecCreatorRegistry defaultRegistry = ModelSpecCreatorRegistry.instance;
    protected static final RDFNode nullObject = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    protected static ModelSpec create(ModelSpecCreatorRegistry modelSpecCreatorRegistry, Model model, Resource resource) {
        Resource resource2 = ModelSpecFactory.findSpecificType(resource, JenaModelSpec.ModelSpec);
        ModelSpecCreator modelSpecCreator = modelSpecCreatorRegistry.getCreator(resource2);
        if (modelSpecCreator == null) {
            throw new BadDescriptionException("no model-spec creator found for " + resource2, model);
        }
        return modelSpecCreator.create(resource, model);
    }

    public static ModelSpec createSpec(ModelSpecCreatorRegistry modelSpecCreatorRegistry, Model model) {
        Model model2 = ModelSpecFactory.withSchema(model);
        return ModelSpecFactory.create(modelSpecCreatorRegistry, model2, ModelSpecFactory.findRootByType(model2, JenaModelSpec.ModelSpec));
    }

    public static ModelSpec createSpec(Model model, Resource resource) {
        Model model2 = ModelSpecFactory.withSchema(model);
        return ModelSpecFactory.create(defaultRegistry, model2, (Resource)resource.inModel(model2));
    }

    public static ModelSpec createSpec(Model model) {
        Model model2 = ModelSpecFactory.withSchema(model);
        return ModelSpecFactory.create(defaultRegistry, model2, ModelSpecFactory.findRootByType(model2, JenaModelSpec.ModelSpec));
    }

    public static Model withSchema(Model model) {
        return ModelSpecFactory.withSpecSchema(model);
    }

    public static Resource findRootByType(Model model, Resource resource) {
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, resource);
        if (!stmtIterator.hasNext()) {
            throw new BadDescriptionNoRootException(model, resource);
        }
        Resource resource2 = stmtIterator.nextStatement().getSubject();
        if (stmtIterator.hasNext()) {
            throw new BadDescriptionMultipleRootsException(model, resource);
        }
        return resource2;
    }

    public static Resource findSpecificType(Resource resource, Resource resource2) {
        StmtIterator stmtIterator = resource.listProperties(RDF.type);
        Model model = resource.getModel();
        while (stmtIterator.hasNext()) {
            Resource resource3 = stmtIterator.nextStatement().getResource();
            if (!model.contains(resource3, RDFS.subClassOf, resource2)) continue;
            resource2 = resource3;
        }
        return resource2;
    }

    public static Model withSpecSchema(Model model) {
        Model model2 = ModelFactory.createDefaultModel();
        Model model3 = JenaModelSpec.getSchema();
        model2.add(model);
        ModelSpecFactory.addJMSSubclassesFrom(model2, model3);
        ModelSpecFactory.addDomainTypes(model2, model, model3);
        ModelSpecFactory.addSupertypesFrom(model2, model3);
        ModelSpecFactory.addSupertypesFrom(model2, model);
        return model2;
    }

    protected static void addDomainTypes(Model model, Model model2, Model model3) {
        StmtIterator stmtIterator = model3.listStatements(null, RDFS.domain, nullObject);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Property property = (Property)statement.getSubject().as(class$com$hp$hpl$jena$rdf$model$Property == null ? ModelSpecFactory.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property);
            StmtIterator stmtIterator2 = model2.listStatements(null, property, nullObject);
            while (stmtIterator2.hasNext()) {
                Statement statement2 = stmtIterator2.nextStatement();
                model.add(statement2.getSubject(), RDF.type, statement.getObject());
            }
        }
    }

    protected static void addJMSSubclassesFrom(Model model, Model model2) {
        StmtIterator stmtIterator = model2.listStatements(null, RDFS.subClassOf, nullObject);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            if (!statement.getSubject().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#") || !statement.getResource().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#")) continue;
            model.add(statement);
        }
    }

    protected static void addSupertypesFrom(Model model, Model model2) {
        Model model3 = ModelFactory.createDefaultModel();
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, nullObject);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            StmtIterator stmtIterator2 = model2.listStatements(statement.getResource(), RDFS.subClassOf, nullObject);
            while (stmtIterator2.hasNext()) {
                model3.add(statement.getSubject(), RDF.type, stmtIterator2.nextStatement().getObject());
            }
        }
        model.add(model3);
    }
}

