/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;

public class RDBMakerCreator
implements ModelMakerCreator {
    public ModelMaker create(Model model, Resource resource) {
        return ModelFactory.createModelRDBMaker(RDBMakerCreator.createConnection(model, resource));
    }

    public static IDBConnection createConnection(Model model, Resource resource) {
        Resource resource2 = model.listStatements(resource, JenaModelSpec.hasConnection, (RDFNode)null).nextStatement().getResource();
        String string = RDBMakerCreator.getURL(model, resource2, JenaModelSpec.dbURL);
        String string2 = RDBMakerCreator.getString(model, resource2, JenaModelSpec.dbUser);
        String string3 = RDBMakerCreator.getString(model, resource2, JenaModelSpec.dbPassword);
        String string4 = RDBMakerCreator.getClassName(model, resource2);
        String string5 = RDBMakerCreator.getString(model, resource2, JenaModelSpec.dbType);
        RDBMakerCreator.loadDrivers(string5, string4);
        return ModelFactory.createSimpleRDBConnection(string, string2, string3, string5);
    }

    public static String getClassName(Model model, Resource resource) {
        Statement statement = model.getProperty(resource, JenaModelSpec.dbClass);
        return statement == null ? null : statement.getString();
    }

    public static String getURL(Model model, Resource resource, Property property) {
        return model.getRequiredProperty(resource, property).getResource().getURI();
    }

    public static String getString(Model model, Resource resource, Property property) {
        return model.getRequiredProperty(resource, property).getString();
    }

    public static void loadDrivers(String string, String string2) {
        try {
            Class.forName("com.hp.hpl.jena.db.impl.Driver_" + string);
            if (string2 != null) {
                Class.forName(string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JenaException(classNotFoundException);
        }
    }
}

