/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.ExprNumeric;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.NodeValueSettable;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_Modulus
extends ExprNode
implements Expr,
ExprNumeric {
    Expr left;
    Expr right;
    private String printName = "mod";
    private String opSymbol = "%";

    Q_Modulus(int n) {
        super(n);
    }

    Q_Modulus(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public NodeValue eval(Query query, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query, indexValues);
        NodeValue nodeValue2 = this.right.eval(query, indexValues);
        if (!nodeValue.isNumber()) {
            throw new EvalTypeException("Q_Modulus: Wanted a number: " + nodeValue);
        }
        if (!nodeValue2.isNumber()) {
            throw new EvalTypeException("Q_Modulus: Wanted a number: " + nodeValue2);
        }
        NodeValueSettable nodeValueSettable = nodeValue instanceof NodeValueSettable ? (NodeValueSettable)nodeValue : (nodeValue2 instanceof NodeValueSettable ? (NodeValueSettable)nodeValue2 : new WorkingVar());
        if (nodeValue.isInt() && nodeValue2.isInt()) {
            nodeValueSettable.setInt(nodeValue.getInt() % nodeValue2.getInt());
        } else {
            nodeValueSettable.setDouble(nodeValue.getDouble() % nodeValue2.getDouble());
        }
        return nodeValueSettable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_Modulus: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (n == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

