/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.ExprNumeric;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_UnaryMinus
extends ExprNode
implements ExprNumeric {
    Expr expr;
    private String printName = "unaryminus";
    private String opSymbol = "-";

    Q_UnaryMinus(int n) {
        super(n);
    }

    Q_UnaryMinus(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public NodeValue eval(Query query, IndexValues indexValues) {
        NodeValue nodeValue = this.expr.eval(query, indexValues);
        if (!nodeValue.isNumber()) {
            throw new EvalTypeException("Q_UnaryMinus: Wanted a number: got " + this.expr);
        }
        WorkingVar workingVar = new WorkingVar();
        if (nodeValue.isInt()) {
            workingVar.setInt(-nodeValue.getInt());
        } else {
            workingVar.setDouble(-nodeValue.getDouble());
        }
        return workingVar;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryMinus: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.expr instanceof Expression) {
            return (Expression)((Object)this.expr);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.expr, null, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

