/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.PrintUtil;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RuleDerivation
implements Derivation {
    protected Rule rule;
    protected Triple conclusion;
    protected List matches;
    protected InfGraph infGraph;

    public RuleDerivation(Rule rule, Triple triple, List list, InfGraph infGraph) {
        this.rule = rule;
        this.conclusion = triple;
        this.matches = list;
        this.infGraph = infGraph;
    }

    public String toString() {
        if (this.rule == null) {
            return "DUMMY";
        }
        return "Rule " + this.rule.toShortString();
    }

    public void printTrace(PrintWriter printWriter, boolean bl) {
        this.printTrace(printWriter, bl, 0, new HashSet());
    }

    protected void printTrace(PrintWriter printWriter, boolean bl, int n, HashSet hashSet) {
        PrintUtil.printIndent(printWriter, n);
        printWriter.print(this.toString());
        if (bl) {
            printWriter.print(" concluded " + PrintUtil.print(this.conclusion));
        }
        printWriter.println(" <-");
        int n2 = n + 4;
        for (int i = 0; i < this.matches.size(); ++i) {
            Object object;
            Triple triple = (Triple)this.matches.get(i);
            Iterator iterator = this.infGraph.getDerivation(triple);
            if (iterator == null || !iterator.hasNext()) {
                PrintUtil.printIndent(printWriter, n2);
                if (triple == null) {
                    object = this.rule.getBodyElement(i);
                    if (object instanceof Functor) {
                        printWriter.println(((Functor)object).getName() + "()");
                        continue;
                    }
                    printWriter.println("call to built in");
                    continue;
                }
                printWriter.println("Fact " + PrintUtil.print(triple));
                continue;
            }
            object = (RuleDerivation)iterator.next();
            if (hashSet.contains(object)) {
                PrintUtil.printIndent(printWriter, n2);
                printWriter.println("Known " + PrintUtil.print(triple) + " - already shown");
                continue;
            }
            hashSet.add(object);
            ((RuleDerivation)object).printTrace(printWriter, bl, n2, hashSet);
        }
    }

    public Triple getConclusion() {
        return this.conclusion;
    }

    public List getMatches() {
        return this.matches;
    }

    public Rule getRule() {
        return this.rule;
    }
}

