/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class QueryMapper {
    private Query query;
    private Node[] variables;
    private Graph graph;
    static final String varPrefix = "jqv:";

    public QueryMapper(Model model, Resource[] resourceArray) {
        this.graph = this.toQueryGraph(model);
        this.query = new Query(this.graph);
        this.variables = this.toQueryVariables(resourceArray);
    }

    public Node[] getVariables() {
        return this.variables;
    }

    public Query getQuery() {
        return this.query;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph toQueryGraph(Model model) {
        StmtIterator stmtIterator = model.listStatements();
        Graph graph = Factory.createDefaultGraph();
        while (stmtIterator.hasNext()) {
            graph.add(this.toQueryTriple(stmtIterator.nextStatement()));
        }
        return graph;
    }

    public Triple toQueryTriple(Statement statement) {
        return Triple.create(this.toQueryNode(statement.getSubject()), this.toQueryNode(statement.getPredicate()), this.toQueryNode(statement.getObject()));
    }

    public Node[] toQueryVariables(Resource[] resourceArray) {
        Node[] nodeArray = new Node[resourceArray.length];
        for (int i = 0; i < resourceArray.length; ++i) {
            nodeArray[i] = this.toQueryNode(resourceArray[i]);
        }
        return nodeArray;
    }

    public Node toQueryNode(RDFNode rDFNode) {
        Node node = rDFNode.asNode();
        return node.isURI() && node.getURI().startsWith(varPrefix) ? Node.createVariable(node.getURI().substring(varPrefix.length())) : node;
    }
}

