/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.javacode.RDFPropertyAtClassCode;
import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JavaCodeGenerator {
    private OWLModel owlModel;
    private JavaCodeGeneratorOptions options;
    private static Map primitiveTypesMap = new HashMap();

    static {
        primitiveTypesMap.put(Integer.class, Integer.TYPE);
        primitiveTypesMap.put(Float.class, Float.TYPE);
        primitiveTypesMap.put(Boolean.class, Boolean.TYPE);
    }

    public JavaCodeGenerator(OWLModel owlModel, JavaCodeGeneratorOptions options) {
        String pack;
        this.owlModel = owlModel;
        this.options = options;
        File folder = options.getOutputFolder();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        if ((pack = options.getPackage()) != null) {
            pack = pack.replace('.', '/');
            File file = folder == null ? new File(pack) : new File(folder, pack);
            file.mkdirs();
            File f = new File(file, "impl");
            f.mkdirs();
        } else {
            File file = folder == null ? new File("impl") : new File(folder, "impl");
            file.mkdirs();
        }
    }

    public void createAll() throws IOException {
        for (RDFSNamedClass aClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            this.createInterface(aClass);
            this.createImplementation(aClass);
        }
        this.createFactoryClass();
    }

    public void createFactoryClass() throws IOException {
        String localName = this.options.getFactoryClassName();
        if (localName != null && localName.length() > 0) {
            File file = this.getInterfaceFile(localName);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printFactoryClass(printWriter);
            fileWriter.close();
        }
    }

    private void printFactoryClass(PrintWriter printWriter) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class " + this.options.getFactoryClassName() + " {");
        printWriter.println();
        printWriter.println("    private OWLModel owlModel;");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + this.options.getFactoryClassName() + "(OWLModel owlModel) {");
        printWriter.println("        this.owlModel = owlModel;");
        printWriter.println("    }");
        for (RDFSNamedClass cls : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            String interfaceName = this.getInterfaceName(cls);
            printWriter.println();
            printWriter.println();
            printWriter.println("    public RDFSNamedClass get" + interfaceName + "Class() {");
            printWriter.println("        final String uri = \"" + cls.getURI() + "\";");
            printWriter.println("        final String name = owlModel.getResourceNameForURI(uri);");
            printWriter.println("        return owlModel.getRDFSNamedClass(name);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + interfaceName + " create" + interfaceName + "(String name) {");
            printWriter.println("        final RDFSNamedClass cls = get" + interfaceName + "Class();");
            printWriter.println("        return (" + interfaceName + ") cls.createInstance(name).as(" + interfaceName + ".class);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + interfaceName + " get" + interfaceName + "(String name) {");
            printWriter.println("        return (" + interfaceName + ") owlModel.getRDFResource(name).as(" + interfaceName + ".class);");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    public void createImplementation(RDFSNamedClass cls) throws IOException {
        File file = this.getImplementationFile(cls);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printImplementationCode(printWriter, cls);
        fileWriter.close();
        if (this.options.getAbstractMode()) {
            this.createUserImplementation(cls);
        }
    }

    public void createUserImplementation(RDFSNamedClass cls) throws IOException {
        String localName = this.getImplementationName(cls);
        File file = this.getImplementationFile(localName);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserImplementationCode(printWriter, cls);
            fileWriter.close();
        }
    }

    public void printImplementationCode(PrintWriter printWriter, RDFSNamedClass aClass) {
        RDFSClassCode code = new RDFSClassCode(aClass);
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.*;");
        this.perhapsAddImportJavaUtil(code, printWriter);
        String pack = this.options.getPackage();
        if (pack != null) {
            printWriter.println("import " + pack + ".*;");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" * Source OWL Class: " + aClass.getURI());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        String implementationName = this.getImplementationNamePossiblyAbstract(aClass);
        printWriter.println("public class " + implementationName + this.getImplementationExtendsCode(aClass));
        printWriter.println("         implements " + this.getInterfaceNamePossiblyAbstract(aClass) + " {");
        this.printConstructors(printWriter, implementationName);
        Iterator it = code.getPropertyCodes().iterator();
        while (it.hasNext()) {
            printWriter.println();
            printWriter.println();
            RDFPropertyAtClassCode propertyCode = (RDFPropertyAtClassCode)it.next();
            this.printImplementationPropertyCode(printWriter, propertyCode);
        }
        printWriter.println("}");
    }

    public void printUserImplementationCode(PrintWriter printWriter, RDFSNamedClass cls) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.*;");
        String pack = this.options.getPackage();
        if (pack != null) {
            printWriter.println("import " + pack + ".*;");
            printWriter.println();
        }
        String implementationName = this.getImplementationName(cls);
        printWriter.println("public class " + implementationName + " extends " + this.getImplementationNamePossiblyAbstract(cls));
        printWriter.println("         implements " + this.getInterfaceName(cls) + " {");
        this.printConstructors(printWriter, implementationName);
        printWriter.println("}");
    }

    private void printConstructors(PrintWriter printWriter, String implementationName) {
        printWriter.println();
        printWriter.println("    public " + implementationName + "(OWLModel owlModel, FrameID id) {");
        printWriter.println("        super(owlModel, id);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + implementationName + "() {");
        printWriter.println("    }");
    }

    private String getImplementationExtendsCode(RDFSNamedClass aClass) {
        String str = " extends ";
        String base = this.getBaseImplementation(aClass);
        if (base == null) {
            return String.valueOf(str) + "DefaultRDFIndividual";
        }
        return String.valueOf(str) + base;
    }

    public void createInterface(RDFSNamedClass aClass) throws IOException {
        File baseFile = this.getInterfaceFile(aClass);
        FileWriter fileWriter = new FileWriter(baseFile);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfaceCode(printWriter, aClass);
        fileWriter.close();
        if (this.options.getAbstractMode()) {
            this.createUserInterface(aClass);
        }
    }

    private void createUserInterface(RDFSNamedClass aClass) throws IOException {
        String localName = this.getInterfaceName(aClass);
        File file = this.getInterfaceFile(localName);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserInterfaceCode(printWriter, aClass);
            fileWriter.close();
        }
    }

    public void printInterfaceCode(PrintWriter printWriter, RDFSNamedClass aClass) {
        RDFSClassCode code = new RDFSClassCode(aClass);
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println();
        this.perhapsAddImportJavaUtil(code, printWriter);
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" * Source OWL Class: " + aClass.getURI());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceNamePossiblyAbstract(aClass) + this.getInterfaceExtendsCode(aClass) + " {");
        Iterator it = code.getPropertyCodes().iterator();
        while (it.hasNext()) {
            RDFPropertyAtClassCode propertyCode = (RDFPropertyAtClassCode)it.next();
            this.createInterfacePropertyCode(printWriter, propertyCode);
            if (!it.hasNext()) continue;
            printWriter.println();
        }
        printWriter.println("}");
    }

    private void printInterfacePackageStatement(PrintWriter printWriter) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
    }

    public void printUserInterfaceCode(PrintWriter printWriter, RDFSNamedClass cls) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("public interface " + this.getInterfaceName(cls) + " extends " + this.getInterfaceNamePossiblyAbstract(cls) + " {");
        printWriter.println("}");
    }

    private String getInterfaceExtendsCode(RDFSNamedClass aClass) {
        String str = " extends ";
        String base = this.getBaseInterface(aClass);
        if (base == null) {
            return String.valueOf(str) + "RDFIndividual";
        }
        return String.valueOf(str) + base;
    }

    public void printImplementationPropertyCode(PrintWriter printWriter, RDFPropertyAtClassCode propertyCode) {
        RDFProperty property = propertyCode.getRDFProperty();
        String name = propertyCode.getUpperCaseJavaName();
        String javaTypeName = this.getJavaTypeName(propertyCode);
        String simpleJavaTypeName = propertyCode.getJavaType();
        boolean multiple = propertyCode.isMultiple();
        String getProperty = "get" + name + "Property()";
        printWriter.println();
        printWriter.println("    // Property " + property.getURI());
        printWriter.println();
        printWriter.println("    public " + javaTypeName + " get" + name + "() {");
        if (multiple) {
            if (this.options.getSetMode()) {
                if (propertyCode.isCustomType()) {
                    printWriter.println("        return new HashSet(getPropertyValuesAs(" + getProperty + ", " + simpleJavaTypeName + ".class));");
                } else {
                    printWriter.println("        return new HashSet(getPropertyValues(" + getProperty + "));");
                }
            } else if (propertyCode.isCustomType()) {
                printWriter.println("        return getPropertyValuesAs(" + getProperty + ", " + simpleJavaTypeName + ".class);");
            } else {
                printWriter.println("        return getPropertyValues(" + getProperty + ");");
            }
        } else if (propertyCode.isPrimitive()) {
            String x = Character.toUpperCase(javaTypeName.charAt(0)) + javaTypeName.substring(1);
            printWriter.println("        return getPropertyValueLiteral(" + getProperty + ").get" + x + "();");
        } else if (propertyCode.isCustomType()) {
            printWriter.println("        return (" + javaTypeName + ") getPropertyValueAs(" + getProperty + ", " + simpleJavaTypeName + ".class);");
        } else {
            printWriter.println("        return (" + javaTypeName + ") getPropertyValue(" + getProperty + ");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public RDFProperty get" + name + "Property() {");
        printWriter.println("        final String uri = \"" + property.getURI() + "\";");
        printWriter.println("        final String name = getOWLModel().getResourceNameForURI(uri);");
        printWriter.println("        return getOWLModel().getRDFProperty(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public boolean has" + name + "() {");
        printWriter.println("        return getPropertyValueCount(" + getProperty + ") > 0;");
        printWriter.println("    }");
        String varName = "new" + name;
        if (multiple) {
            printWriter.println();
            printWriter.println();
            printWriter.println("    public Iterator list" + name + "() {");
            if (propertyCode.isCustomType()) {
                printWriter.println("        return listPropertyValuesAs(" + getProperty + ", " + simpleJavaTypeName + ".class);");
            } else {
                printWriter.println("        return listPropertyValues(" + getProperty + ");");
            }
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            printWriter.println("    public void add" + name + "(" + simpleJavaTypeName + " " + varName + ") {");
            printWriter.println("        addPropertyValue(" + getProperty + ", " + varName + ");");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            String oldVarName = "old" + name;
            printWriter.println("    public void remove" + name + "(" + simpleJavaTypeName + " " + oldVarName + ") {");
            printWriter.println("        removePropertyValue(" + getProperty + ", " + oldVarName + ");");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    public void set" + name + "(" + javaTypeName + " " + varName + ") {");
        if (multiple) {
            printWriter.println("        setPropertyValues(" + getProperty + ", " + varName + ");");
        } else if (propertyCode.isPrimitive()) {
            String t = null;
            t = "int".equals(javaTypeName) ? "Integer" : ("boolean".equals(javaTypeName) ? "Boolean" : "Float");
            printWriter.println("        setPropertyValue(" + getProperty + ", new " + t + "(" + varName + "));");
        } else {
            printWriter.println("        setPropertyValue(" + getProperty + ", " + varName + ");");
        }
        printWriter.println("    }");
    }

    public void createInterfacePropertyCode(PrintWriter printWriter, RDFPropertyAtClassCode propertyCode) {
        RDFProperty property = propertyCode.getRDFProperty();
        String name = propertyCode.getUpperCaseJavaName();
        String javaTypeName = this.getJavaTypeName(propertyCode);
        printWriter.println();
        printWriter.println("    // Property " + property.getURI());
        printWriter.println();
        printWriter.println("    " + javaTypeName + " get" + name + "();");
        printWriter.println();
        printWriter.println("    RDFProperty get" + name + "Property();");
        printWriter.println();
        printWriter.println("    boolean has" + name + "();");
        if (propertyCode.isMultiple()) {
            String simpleJavaTypeName = propertyCode.getJavaType();
            printWriter.println();
            printWriter.println("    Iterator list" + name + "();");
            printWriter.println();
            printWriter.println("    void add" + name + "(" + simpleJavaTypeName + " new" + name + ");");
            printWriter.println();
            printWriter.println("    void remove" + name + "(" + simpleJavaTypeName + " old" + name + ");");
        }
        printWriter.println();
        printWriter.println("    void set" + name + "(" + javaTypeName + " new" + name + ");");
    }

    private String getJavaTypeName(RDFPropertyAtClassCode propertyCode) {
        if (propertyCode.isMultiple()) {
            return this.options.getSetMode() ? "Set" : "Collection";
        }
        return propertyCode.getJavaType();
    }

    public String getBaseImplementation(RDFSNamedClass aClass) {
        for (RDFSClass superclass : aClass.getSuperclasses(false)) {
            String name = this.getSystemJavaClass(superclass);
            if (name != null) {
                return "Default" + name;
            }
            if (!(superclass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(superclass)) continue;
            return this.getImplementationName((RDFSNamedClass)superclass);
        }
        return null;
    }

    public String getBaseInterface(RDFSNamedClass cls) {
        for (RDFSClass superclass : cls.getSuperclasses(false)) {
            String name = this.getSystemJavaClass(superclass);
            if (name != null) {
                return name;
            }
            if (!(superclass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(superclass)) continue;
            return this.getInterfaceName((RDFSNamedClass)superclass);
        }
        return cls.getProtegeType() instanceof OWLNamedClass ? "OWLIndividual" : "RDFIndividual";
    }

    public File getImplementationFile(RDFSNamedClass aClass) {
        String localName = this.getImplementationNamePossiblyAbstract(aClass);
        return this.getImplementationFile(localName);
    }

    private File getImplementationFile(String localName) {
        String pack = this.options.getPackage();
        pack = pack != null ? String.valueOf(pack.replace('.', '/')) + "/" : "";
        return new File(this.options.getOutputFolder(), String.valueOf(pack) + "impl/" + localName + ".java");
    }

    public String getImplementationName(RDFSNamedClass aClass) {
        return "Default" + this.getInterfaceName(aClass);
    }

    public String getImplementationNamePossiblyAbstract(RDFSNamedClass aClass) {
        return "Default" + this.getInterfaceNamePossiblyAbstract(aClass);
    }

    public File getInterfaceFile(RDFSNamedClass aClass) {
        String localName = this.getInterfaceNamePossiblyAbstract(aClass);
        return this.getInterfaceFile(localName);
    }

    private File getInterfaceFile(String localName) {
        String pack = this.options.getPackage();
        pack = pack != null ? String.valueOf(pack.replace('.', '/')) + "/" : "";
        return new File(this.options.getOutputFolder(), String.valueOf(pack) + localName + ".java");
    }

    public String getInterfaceNamePossiblyAbstract(RDFSNamedClass aClass) {
        String str = new RDFSClassCode(aClass).getJavaName();
        if (this.options.getAbstractMode()) {
            str = String.valueOf(str) + "_";
        }
        return str;
    }

    public String getInterfaceName(RDFSNamedClass aClass) {
        return new RDFSClassCode(aClass).getJavaName();
    }

    private String getSystemJavaClass(RDFSClass superclass) {
        if (superclass.equals(this.owlModel.getOWLObjectPropertyClass())) {
            return "OWLObjectProperty";
        }
        if (superclass.equals(this.owlModel.getOWLDatatypePropertyClass())) {
            return "OWLDatatypeProperty";
        }
        if (superclass.equals(this.owlModel.getRDFPropertyClass())) {
            return "RDFProperty";
        }
        if (superclass.equals(this.owlModel.getOWLNamedClassClass())) {
            return "OWLNamedClass";
        }
        if (superclass.equals(this.owlModel.getRDFSNamedClassClass())) {
            return "RDFSNamedClass";
        }
        return null;
    }

    public static String getValidJavaName(String name) {
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                name = name.replace(c, '_');
            }
            ++i;
        }
        return name;
    }

    private void perhapsAddImportJavaUtil(RDFSClassCode code, PrintWriter printWriter) {
        for (RDFPropertyAtClassCode propertyAtClassCode : code.getPropertyCodes()) {
            if (!propertyAtClassCode.isMultiple()) continue;
            printWriter.println("import java.util.*;");
            printWriter.println();
            return;
        }
    }
}

